import pygame
from Box2D import *
class Object:
    def __init__(self, x, y, width, height, color, world, shape="circle", size=.1):
        self.color = color
        self.body = b2BodyDef()
        if shape is "box":
            shapeDef = b2PolygonDef()
            shapeDef.SetAsBox(size,size)
        else:
            shapeDef = b2CircleDef()
            shapeDef.radius = size
        shapeDef.density = 10
        shapeDef.friction = .3
        self.body = world.CreateBody(self.body)
        self.body.position.Set(x/100.0, y/100.0)
        self.body.CreateShape(shapeDef)
        self.body.SetMassFromShapes()
        self.x = self.body.position.x*100
        self.y = self.body.position.y*100
        self.surf = pygame.Surface((width, height))
        self.surf.fill((255,255,255))
        #pygame.draw.rect(self.surf, color, pygame.Rect(width/10.0, height/10.0, width-width/10.0, height-height/10.0))

    def update(self):
        self.x = self.body.position.x*100
        self.y = self.body.position.y*100
        #self.surf_copy = pygame.transform.rotate(self.surf, self.body.angle)
        #self.surf = self.surf_copy
        
