uniform sampler2D depthTex;

varying mediump vec3 normal;
varying highp vec2 texCoord;
varying highp vec4 shadowCoord;

const highp vec4 unpackFactors = vec4(1.0/(256.0 * 256.0 * 256.0), 1.0/(256.0 * 256.0), 1.0/256.0, 1.0);

void main() {
	highp float comp = (shadowCoord.z / shadowCoord.w) - 0.003;
	highp vec4 col = unpackFactors*texture2DProj(depthTex, shadowCoord);
	highp float depth = col.r+col.g+col.b+col.a;
    

	if(comp - depth > 0.05 && depth < 0.99) // threshold not to look outside camera view frustrum
		gl_FragColor = vec4(vec3(0), 0.5); // shadow
	else
		gl_FragColor = vec4(0); // no shadow (transparency)
}
