/*
 * VideoQuad.cpp
 *
 *  Created on: 22.10.2009
 *      Author: pavel
 */

#ifdef NO_ES
	#include <GL/glew.h>
	#include <GL/gl.h>
#else
	#include <GLES2/gl2.h>
#endif

#include "Interface.h"
#include <QImage>

void Interface::setup() {
    const float aspect = 0.6;
    const float w = 1-aspect*0.2;
    const float h = 0.8;
	const float quad[] = {w,h, 0,  // Pos (top right)
						 0, 0, 1,  // Normal
						 0, 1,     // UV
						 w, 1, 0,
						 0, 0, 1,
						 0, 0,
						 1,h, 0,
						 0, 0, 1,
						 1, 1,
						 1, 1, 0,
						 0, 0, 1,
						 1, 0,
						 -1,h, 0,  // Pos (top left)
                         0, 0, 1,  // Normal
                         0, 1,     // UV
                        -1, 1, 0,
                         0, 0, 1,
                         0, 0,
                         -w,h, 0,
                         0, 0, 1,
                         1, 1,
                         -w, 1, 0,
                         0, 0, 1,
                         1, 0,
                         -1,-1, 0,  // Pos (bottom left)
                         0, 0, 1,  // Normal
                         0, 1,     // UV
                        -1, -h, 0,
                         0, 0, 1,
                         0, 0,
                         -w,-1, 0,
                         0, 0, 1,
                         1, 1,
                         -w, -h, 0,
                         0, 0, 1,
                         1, 0};

	close = getTexture("img/close.png");
	light = getTexture("img/light.png");
	draw = getTexture("img/draw.png");

    glGenBuffers(1, &vbo);
    glBindBuffer(GL_ARRAY_BUFFER, vbo);
    glBufferData(GL_ARRAY_BUFFER, 3*8*4*sizeof(float), quad, GL_STATIC_DRAW);
    glBindBuffer(GL_ARRAY_BUFFER, 0); // unbind
}

unsigned int Interface::getTexture(const char* path) {
    unsigned int id;

    QImage tex;
    tex.load(path);
    tex = QGLWidget::convertToGLFormat(tex);

    glGenTextures(1, &id);
    glBindTexture(GL_TEXTURE_2D, id);
    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, tex.width(), tex.height(), 0, GL_RGBA, GL_UNSIGNED_BYTE, tex.bits());
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glBindTexture(GL_TEXTURE_2D, 0); // unbind

    return id;
}

void Interface::render(QGLShaderProgram& sp) {
    glBindBuffer(GL_ARRAY_BUFFER, vbo);

    sp.enableAttributeArray("vertex");
    sp.setAttributeArray("vertex", 0, 3, 8*sizeof(float));

    sp.enableAttributeArray("norm");
    sp.setAttributeArray("norm", (float*)(3*sizeof(float)), 3, 8*sizeof(float));

    sp.enableAttributeArray("tex");
    sp.setAttributeArray("tex", (float*)(6*sizeof(float)), 2, 8*sizeof(float));

    sp.setUniformValue("ProjModelView", QMatrix4x4());

    glBindTexture(GL_TEXTURE_2D, close);
    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

    glBindTexture(GL_TEXTURE_2D, light);
    glDrawArrays(GL_TRIANGLE_STRIP, 4, 4);

    glBindTexture(GL_TEXTURE_2D, draw);
    glDrawArrays(GL_TRIANGLE_STRIP, 8, 4);

    glBindBuffer(GL_ARRAY_BUFFER, 0); // unbind
    glBindTexture(GL_TEXTURE_2D, 0); // unbind
}

void Interface::cleanup() {
	glDeleteTextures(1, &close);
    glDeleteBuffers(1, &vbo);
}
