#include <QWidget>
#include <QObject>
#include <QPushButton>
#include <QRadioButton>
#include <QLineEdit>
#include <QTimer>
#include <QDialog>

#include "ConnectionSettings.h"

ConnectionSettings::ConnectionSettings(QWidget *parent): QDialog(parent)
 {
    //initialize
    setProxy = new QRadioButton ("Use Proxy");
    setProxy->setChecked(true);
    testSettingsButton = new QPushButton ("Test Connection");
    proxyPort = new QLineEdit ("8080");
    proxyHost = new QLineEdit ("172.16.42.133");
    successLabel = new QLabel ();
    successLabel->setEnabled (false);
    verticalLayout = new QVBoxLayout();
    this->setWindowTitle ("Connection settings");
    //this->setFixedSize (800,480);

    //connect elements
    connect (setProxy, SIGNAL(clicked(bool)),proxyPort,SLOT(setEnabled(bool)));
    connect (setProxy, SIGNAL(clicked(bool)),proxyHost,SLOT(setEnabled(bool)));
    connect (testSettingsButton, SIGNAL (clicked(bool)),this,SLOT(connectionTest(bool)));

    //compose layout
    verticalLayout->addWidget(setProxy);
    verticalLayout->addWidget(proxyHost);
    verticalLayout->addWidget(proxyPort);
    verticalLayout->addWidget(successLabel);
    verticalLayout->addWidget(testSettingsButton);

    //add layout to window
    this->setLayout (verticalLayout);
}


void ConnectionSettings::connectionTest(bool) {
    /*  check if proxy-server is used
        and if in this case the variables are set */
    QTextStream out (stdout);
    int port;
    QString host;

    if (setProxy->isChecked()) {
        out << "checked" << endl;
        if (proxyPort->displayText()!=""&&proxyHost->displayText()!="") {
            bool isInt;
            host=proxyHost->displayText();
            port = proxyPort->displayText().toInt(&isInt,10);
            if (!isInt) {
                out << "not an integer" << endl;
            }
        } else {
            out << "something is missing here. specify host and port" << endl;
        }
    }
    /* build up the connection */
    testConnection = new HttpConnector();
    connect (testConnection, SIGNAL(getResponseStatus(int,bool,QString)),this,SLOT(responseStatus(int,bool,QString)));

    /*get signal when its done*/
    if (setProxy->isChecked()) {
        out << host + QString::number (port) << endl;
        testConnection->setProxy (host,port);
    } else {
        out << "no" << endl;
    }
    testConnection->connectToHost("http://maemo.org");
}

void ConnectionSettings::responseStatus(int code, bool error, QString msg) {
    if (error) {
        successLabel->setText (msg);
    } else {
        successLabel->setText ("Connection OK!");
    }
    successLabel->setEnabled(true);
    this->repaint();
}
