# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Standard Manupilation modules that are not directly UI based.
"""
from PyQt4.QtCore import pyqtSignature
from PIL import Image
from filters.toolbox import *
from core import *
from filters.display import *
from filters.rotate import *
from filters.imageExif import *
import math
import os.path


def FileOpenReleased(self):
    """
    Key Press to launch File open dialog, store image and display on GUI
    """
    ImgTemp= str(QtGui.QFileDialog.getOpenFileName(self, 'Open File', '/home/user/MyDocs/DCIM/', ("Images (*.png *.jpg)")))
    if ImgTemp != "":
        self.core.current.imageageLoc = ImgTemp
    FileImageOpen(self,  self.core.curImageLoc)
    
def FileImageOpen(self,  filename):
    """
    Open File and poulate class parameters of Image.
    """
    try:
        #ToggleThumbWait(self, True)
        self.repaint()
        del self.core.undoList_IM[:]
        self.core.current.image = (Image.open(filename))
        self.core.curImageLoc = filename
        FileImageRefresh(self)
        
    except:
        print "Error: FileImageOpen:"+filename
        return

def FileImageRefresh(self,  loadUndo=1):
    print "FileImageRefresh"
    FileImageLoadSizes(self)
    self.core.UndoImage_Push()
    FileImageDisplayRefresh(self)

        
def FileImageLoadSizes(self):
    try:
        
        self.core.valOrient= GetExifRotation(self, self.core.curImageLoc)
        im=rotateImage(self, self.core.current.image,  self.core.valOrient)
        w, h = im.size
        wTh,  hTh = convertImSize(self.core, w, h,  250,  150,self.core.valOrient,  1)
        #wTh,  hTh = convertImSize(self.core, w, h,  250,  150)

        size = (wTh,  hTh )
        self.core.current.thumb = im.resize(size, Image.ANTIALIAS)
        self.core.current.setThumbDisplaySize(155-int(wTh/2),  195-int(hTh/2), wTh, hTh)
        
        w, h = self.core.current.image.size
        wTh,  hTh = convertImSize(self.core,  w, h,  796,  430)
        self.core.current.setImageDisplaySize(398-int(wTh/2), 216-int(hTh/2), wTh, hTh)
        self.core.EXIFLoaded = False
    except:
        print "FileLoadImage Error"

def FileImageDisplayRefresh(self):
    try:
        ToggleThumbWait(self, True)
        
        self.photo.setGeometry(QRect(0, 0, 0, 0))
        self.photo_Thumb.setGeometry(QRect(0, 0, 0, 0))
        
        self.photo_Thumb.setPixmap(pil2qpixmap(self.core.current.thumb))
        self.photo.setPixmap(pil2qpixmap(self.core.current.image))
        
        self.photo.setGeometry(self.core.current.getImageDisplaySize())
        self.photo_Thumb.setGeometry(self.core.current.getThumbDisplaySize())
        self.btnFullScreen.setGeometry(self.core.current.getThumbDisplaySize())
        
        #ToggleThumbWait(self, False)
    except:
        return
        
def StripFilename(self,  myPath):
    (dirName, fileName) = os.path.split(myPath)
    (fileBaseName, fileExtension)=os.path.splitext(fileName)
    return (dirName, fileBaseName, fileExtension)

def MostRecentImage(self):
    files =[]
    for file in os.listdir(self.core.imageDir):
        files.append(file)


#######################################
#   Save As
#######################################
def DisplaySaveAs(self):
    fileLoc=StripFilename(self, self.core.curImageLoc)
    i = str(self.btnSaveAsGenFilename(fileLoc[0], fileLoc[1]))
    self.btnSaveAs_Filename.setText(fileLoc[1]+"_"+i)
    self.btnSaveAs_Location.setText(fileLoc[0])
    self.titlePop_Name_3.setText(fileLoc[0]+"/"+fileLoc[1]+"_"+i+"."+str(self.btnSaveAs_Combo.currentText()).replace("JPEG", "jpg"))
    self.frameSaveAuto.setVisible(True)
    self.frameSaveAvd.setVisible(False)
    self.frameSaveAs.setGeometry(0, 40, 800, 480)
