# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Module implementing MainWindow GUI, anselA
"""
import glob
import math
import operator
import os
import time
import sys
import webbrowser
from subprocess import call

from PIL import Image
from PIL import ImageDraw
from PIL import ImageEnhance
from PyQt4 import QtCore as QtCore
from PyQt4 import QtGui as QtGui 
from PyQt4.QtCore import pyqtSignature
from PyQt4.QtGui import QMainWindow

from imports.EXIF import *
from core.config import *
from core.browser import *
from core.core import *
from core.buttons import *
from core.files import *
from filters.bw import *
from filters.colors import *
from filters.histogram import *
from filters.imageExif import *
from filters.levels import *
from filters.rotate import *
from filters.toolbox import *
from filters.simple import *
from ui.Ui_mainWindow import Ui_MainWindow
from filters.toolbox import pil2qpixmap


class MainWindow(QMainWindow, Ui_MainWindow,  ParamValues):
    """
    Main Window Class for AnselA
    """
    core=ParamValues()

    #######################################
    #   Initial 
    #######################################

    def __init__(self, parent = None):
        """
        Constructor
        """
        try:
            QMainWindow.__init__(self, parent)
            self.setupUi(self)

        except:
            print "Error: init"
            return
            
    def postShow(self):
        try:
            ReadConfig(self)
            PhotTabs_Hide(self)
            WaitOverlay(self,"Starting...")
            ##FullScreenToggle(self,True, 2)
            self.tabStrip.setCurrentIndex(2)
            ##self.btnFullScreenClose.setGeometry(QtCore.QRect(0, 0, 0, 0))
            self.photo.setMouseTracking= True
            populatePhotoList(self)
            WaitOverlayHide(self)
            self.listPhotositemLoad(self.listPhotos.item(0))
            ##reply = QtGui.QMessageBox.question(self, 'Message',"Are you sure to quit?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
       
            if (self.listPhotos.item(0) == None):
                FileImageOpen(self,  self.core.curImageLoc)
            ShowApply(self, False)
            self.core.plotIm=Image.open("/opt/anselA/ui/resources/graph.png") 
        except:
            print "Error: postShow"
            

    #######################################
    #   Color Sliders
    #######################################
    def on_cSlide_B_valueChanged(self, value):
        if (self.core.valB <> value):
            self.core.valB = cSlide_SetValue(self, value,  self.core.valB,  self.lcdB, self.cSlide_B)
        
    def on_btnSlide_B_up_pressed(self):
        self.core.valB = cSlide_ShiftValue(self,  1,  self.core.valB,  self.lcdB, self.cSlide_B)
        
    def on_btnSlide_B_dn_pressed(self):
        self.core.valB = cSlide_ShiftValue(self, -1,  self.core.valB,  self.lcdB, self.cSlide_B)

    @pyqtSignature("int")
    def on_cSlide_R_valueChanged(self, value):
        """
        Set Red Value
        """
        if (self.core.valR <> value):
            self.core.valR = cSlide_SetValue(self, value,  self.core.valR,  self.lcdR, self.cSlide_R)
        
    def on_btnSlide_R_dn_pressed(self):
        self.core.valR = cSlide_ShiftValue(self,  -1,  self.core.valR,  self.lcdR, self.cSlide_R)
        
    def on_btnSlide_R_up_pressed(self):
        self.core.valR = cSlide_ShiftValue(self, 1,  self.core.valR,  self.lcdR, self.cSlide_R)       
    
    @pyqtSignature("int")
    def on_cSlide_G_valueChanged(self, value):
        """
        Set Green Value
        """
        if (self.core.valG <> value):
            self.core.valG = cSlide_SetValue(self, value,  self.core.valG,  self.lcdG, self.cSlide_G)
        
    def on_btnSlide_G_up_pressed(self):
        self.core.valG = cSlide_ShiftValue(self,  1,  self.core.valG,  self.lcdG, self.cSlide_G)
        
    def on_btnSlide_G_dn_pressed(self):
        self.core.valG = cSlide_ShiftValue(self, -1,  self.core.valG,  self.lcdG, self.cSlide_G)
    

  
    #######################################
    #   Level Applys
    #######################################
  
    def on_cSlide_Mi_valueChanged(self, value):
        if (self.core.valMi <> value):
            self.core.valMi = cSlide_SetValue(self, value,  self.core.valMi,  self.lcdMi_2, self.cSlide_Mi)
        
    def on_btnSlide_Mid_dn_pressed(self):
        self.core.valMi= cSlide_ShiftValue(self,  -1,  self.core.valMi,  self.lcdMi_2, self.cSlide_Mi)
            
    def on_btnSlide_Mid_up_pressed(self):
        self.core.valMi = cSlide_ShiftValue(self,  1,  self.core.valMi,  self.lcdMi_2, self.cSlide_Mi)
  
  
    def on_cSlide_Hi_valueChanged(self, value):
        if (self.core.valHi <> value):
            self.core.valHi = cSlide_SetValue(self, value,  self.core.valHi,  self.lcdHi, self.cSlide_Hi)

    def on_btnSlide_H_dn_pressed(self):
        self.core.valHi = cSlide_ShiftValue(self,  -1,  self.core.valHi,  self.lcdHi, self.cSlide_Hi)
        
    def on_btnSlide_H_up_pressed(self):
        self.core.valHi = cSlide_ShiftValue(self,   1,  self.core.valHi,  self.lcdHi, self.cSlide_Hi)
    
    
    def on_cSlide_Sw_valueChanged(self, value):
        if (self.core.valSw <> value):
            self.core.valSw = cSlide_SetValue(self, value,  self.core.valSw,  self.lcdSw, self.cSlide_Sw)
        
    def on_btnSlide_Sha_dn_pressed(self):
        self.core.valSw = cSlide_ShiftValue(self,  -1,  self.core.valSw,  self.lcdSw, self.cSlide_Sw)
        
    def on_btnSlide_Sha_up_pressed(self):
        self.core.valSw = cSlide_ShiftValue(self,   1,  self.core.valSw,  self.lcdSw, self.cSlide_Sw)


   
    #######################################
    #   Level Applys
    #######################################
    
    @pyqtSignature("int")
    def on_cSlide_Co_valueChanged(self, value):
        if (self.core.valCo != value):
            self.core.valCo = cSlide_SetValue(self, value,  self.core.valCo,  self.lcdCo, self.cSlide_Co)
        
    def on_btnSlide_Co_dn_pressed(self):
        self.core.valCo = cSlide_ShiftValue(self,  -1,  self.core.valCo,  self.lcdCo, self.cSlide_Co)
        
    def on_btnSlide_Co_up_pressed(self):
        self.core.valCo = cSlide_ShiftValue(self,   1,  self.core.valCo,  self.lcdCo, self.cSlide_Co)
    
    
    @pyqtSignature("int")
    def on_cSlide_Sh_valueChanged(self, value):
        if (self.core.valSh <> value):
            self.core.valSh = cSlide_SetValue(self, value,  self.core.valSh,  self.lcdSh, self.cSlide_Sh)
            
    def on_btnSlide_Sh_dn_pressed(self):
        self.core.valSh = cSlide_ShiftValue(self,  -1,  self.core.valSh,  self.lcdSh, self.cSlide_Sh)
        
    def on_btnSlide_sh_up_pressed(self):
        self.core.valSh = cSlide_ShiftValue(self,   1,  self.core.valSh,  self.lcdSh, self.cSlide_Sh)

        
    @pyqtSignature("int")
    def on_cSlide_Sa_valueChanged(self, value):
        if (self.core.valSa <> value):
            self.core.valSa = cSlide_SetValue(self, value,  self.core.valSa,  self.lcdSa, self.cSlide_Sa)
    
    def on_btnSlide_Sa_up_pressed(self):
        self.core.valSa = cSlide_ShiftValue(self,   1,  self.core.valSa,  self.lcdSa, self.cSlide_Sa)
        
    def on_btnSlide_Sa_dn_pressed(self):
        self.core.valSa = cSlide_ShiftValue(self,  -1,  self.core.valSa,  self.lcdSa, self.cSlide_Sa)
        
    
    @pyqtSignature("int")
    def on_cSlide_Br_valueChanged(self, value):
        if (self.core.valBr <> value):
            self.core.valBr = cSlide_SetValue(self, value,  self.core.valBr,  self.lcdBr, self.cSlide_Br)
    
    def on_btnSlide_Br_dn_pressed(self):
        self.core.valBr = cSlide_ShiftValue(self,  -1,  self.core.valBr,  self.lcdBr, self.cSlide_Br)
        
    def on_btnSlide_Br_up_pressed(self):
        self.core.valBr = cSlide_ShiftValue(self,  1,  self.core.valBr,  self.lcdBr, self.cSlide_Br)
        
        
        
    @pyqtSignature("int")
    def on_dial_valueChanged(self, value):
        if  (self.core.lockUpdating == False):
            self.core.valRot = value
            self.lcdRot_1.setText(str(self.core.valRot))
            RotateThumb(self,  value)
           

    #######################################
    #   UI Reactions
    #######################################

    def on_btnExitCancel_released(self):
        self.tabStrip.setCurrentIndex(self.core.GetCurrentTab(self))
        self.FramePopup.setGeometry(QtCore.QRect(0, 0, 0, 0))
        
    def on_btnPopOk_released(self):
        sys.exit()
    
    def on_btnPopCancel_released(self):
        self.tabStrip.setCurrentIndex(self.core.GetCurrentTab(self))
        self.FramePopup.setGeometry(QtCore.QRect(0, 0, 0, 0))

    def on_minMax_released(self):
        return MinMax()
        
    def on_photo_released(self):
        QMessageBox.information(self, "Loading Data", "Please wait while the data is retrieved...")

   
    def on_btnOpen_released(self):
        return FileOpenReleased(self)
       
    def PopulateEXIFData(self,  filename):
        return ImageExifLoad(self)
        
    def on_tabPhoto_currentChanged(self, index):
        if (self.tabPhoto.count != 1):
            if (index == 2):
                ##self.btnFullScreenClose.setGeometry(QtCore.QRect(0, 0, 0, 0))
                if self.core.thumbsCount == 0:
                    return populatePhotoList(self)
                self.photoListZoom.setVisible(False)
            elif (index ==1):
               self.loadUndoImages()
        else:
            #self.btnFullScreenClose.setGeometry(QtCore.QRect(0, 0, 0, 0))
            if self.core.thumbsCount == 0:
                return populatePhotoList(self)
                
    def loadUndoImages(self):
        self.btnUndoCancel.setVisible(False)
        self.btnUndoGo.setVisible(False)
        i = 0
        self.listUndoList.clear()
        for uIm in self.core.undoList_IM:
            icon =QtGui.QIcon(pil2qpixmap(uIm.thumb))
            if (i == 0):
                self.listUndoList.addItem("Original")
            else:
                self.listUndoList.addItem("Step: "+str(i))
                
            self.listUndoList.item(i).setIcon(icon)
            i+=1
                

    #######################################
    #  Full Screen
    #######################################

    def on_btnFullScreen_released(self):
        """
        Button handler for fullscreen  open, calls FullScreenToggle
        """
        FullScreenToggle(self,True)
    

    def on_btnFullScreenClose_released(self):
        FullScreenToggle(self,False)

    
    def on_tabStrip_currentChanged(self, index):
        if (index==9):
            self.FramePopup.setGeometry(QtCore.QRect(0, 0, 800, 480))
        elif  (index==6):
            ReturnHistPlots(self)
        elif (index==7):
            self.PopulateEXIFData(self.core.curImageLoc)
        else:
            self.core.SetCurrentTab(self.tabStrip.currentIndex() )
        
    #######################################
    #   B & W Settings
    #######################################
    def on_btn_Grey_released(self):
        self.core.valBW = "L"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    def on_btn_Red_released(self):
        self.core.valBW = "R"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)

    def on_btn_Green_released(self):
        self.core.valBW = "G"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    def on_btn_Blue_released(self):
        self.core.valBW = "B"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
 
    def on_btn_Yellow_released(self):
        self.core.valBW = "Y"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    def on_btn_Cyan_released(self):
        self.core.valBW = "C"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    def on_btn_Magenta_released(self):
        self.core.valBW = "M"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
        
    def on_btn_BC_released(self):
        self.core.valBW = "BC"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    def on_btn_GC_released(self):
        self.core.valBW = "GC"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    def on_btn_GY_released(self):
        self.core.valBW = "GY"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    def on_btn_BM_released(self):
        self.core.valBW = "BM"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
        
    def on_btn_RM_released(self):
        self.core.valBW = "RM"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    def on_btn_RY_released(self):
        self.core.valBW = "RY"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)


    def on_btnBug_released(self):
        """
        Submit bug report to bugs.maemo.org
        """ 
        url='https://bugs.maemo.org/enter_bug.cgi?product=AnselA'
        os.system('browser --url=%s' %url)


    #######################################
    #   Photo Browser
    #######################################

    def on_btnPListCancel_released(self):
        self.frameCancelPListLoad.setGeometry(QtCore.QRect(0, 0, 0, 0))
        self.core.populatePhotoList = False

    def on_btnPlistZoom_released(self):
        AnimateWidget(self, self.photoListZoom, 155-int(self.photoListZoom.width()/2) , 195-int(self.photoListZoom.height()/2), 0, 0, 10)
        LoadCurImageFromPhotoBrowser(self)

    def on_butReturn_released(self):
        FullScreenToggle(self,False)
    
    def on_listPhotos_itemDoubleClicked(self, item):
        #((155-int(self.photoListZoom.width()/2)) , 0, 0, 0, 10))
        AnimateWidget(self, self.photoListZoom, 155-int(self.photoListZoom.width()/2) , 195-int(self.photoListZoom.height()/2), 0, 0, 10)
        LoadCurImageFromPhotoBrowser(self)
    
    def on_btnReloadPList_released(self):
        self.frameReloadRequest.setGeometry(QtCore.QRect(0, 0, 800, 480))
    
    def on_btnReloadCancel_released(self):
        self.frameReloadRequest.setGeometry(QtCore.QRect(0, 0, 0, 0))
    
    def on_btnReloadGo_released(self):
        #self.btnEdit.setGeometry(QtCore.QRect(0, 0, 0, 0))
        self.frameReloadRequest.setGeometry(QtCore.QRect(0, 0, 0, 0))
        populatePhotoList(self,  True)
  
    def on_btnRefresh_pressed(self):
        populatePhotoList(self)

    def on_btnPhotoBrowser_released(self):
        FullScreenToggle(self,True,  2)
        
        if self.core.thumbsCount == 0:
            self.populatePhotoList(self,  True)
    
    def on_listPhotos_itemClicked(self, item):
       #return listPhotosClicked()
        if str(item.text()) == "Load More...":
            self.core.thumbsCount +=100
            populatePhotoList(self,  False)

            self.btnEditZoomed.setGeometry(QtCore.QRect(40, 120, 250, 150))
        else:
            self.listPhotositemLoad(item)
            
    def listPhotositemLoad(self, item):
        if (item <> None):
            
            self.core.plistIm= item.getImageLocation()
            im = Image.open(self.core.plistIm)
            item.rotation= GetExifRotation(self, item.imageLocation)
            im = rotateImage(self, im, item.rotation)
            
            wTh,  hTh = convertImSize(self.core, im.size[0], im.size[1],  250,  150, item.rotation,  1) #This should be the same size as the thumbnailbnails
            item.setIconZoomSize(self.ScaleLabel(195,  400, hTh, wTh))
            
            self.photoListZoom.setGeometry(item.getIconZoomSize())
            self.btnPlistZoom.setGeometry(self.photoListZoom.geometry())
            
            plistTim=im.resize((hTh,  wTh))
            self.photoListZoom.setPixmap(pil2qpixmap(plistTim))
            
            self.photoListZoom.setVisible(True)
            self.photoListZoom.repaint()
        

    def on_listUndoList_itemPressed(self, item):
        self.btnUndoCancel.setVisible(True)
        self.btnUndoGo.setVisible(True)
        if (str(item.text()) == "Original"):
            self.core.undoSelected = 0
        else:
            self.core.undoSelected = str(item.text().replace("Step: ",""))
        self.btnUndoGo.setText("Revert to "+str(item.text()))


    @pyqtSignature("int, int, int, int")
    def ScaleLabel(self, yH, xW, h, w):
        """
        Send widget x(Width), y(Height) of center point
        and h,w of image passed.
        """
        return QtCore.QRect(xW-int(w/2), yH-int(h/2), w, h)
    
    #######################################
    #   Apply and Undo
    #######################################
    def on_btnApply_released(self):
        """
        Apply based on tab selection
        """
        ApplyGo(self)

    def on_btnUndoGo_released(self):
        UndoGo(self)
       
        
    #######################################
    #   Rotation
    #######################################    
    def on_btn_rot_Vert_released(self):
        self.core.flipRight = not self.core.flipRight 
        FlipThumb(self)
        
    def on_btn_rot_Horz_pressed(self):
        self.core.flipBottom = not self.core.flipBottom 
        FlipThumb(self)
        
    def on_btn_rot_90cw_released(self):
        self.core.valRot = 270
        RotateThumb(self,  self.core.valRot)

    def on_btn_rot_90ccw_released(self):
        self.core.valRot = 90
        RotateThumb(self,  self.core.valRot)
        
    def on_btn_rot_180_released(self):
        self.core.valRot = 180
        RotateThumb(self,  self.core.valRot)
    
    
    
    
    #######################################
    #   Save As
    #######################################
    def on_btnSaveAs_released(self):
        self.DisplaySaveAs()


    def on_btnSaveAsCancel_pressed(self):
        self.frameSaveAs.setGeometry(0, 40, 0, 480)
    
        
    def on_btnSaveAsGo_pressed(self):
        WaitOverlay(self,"Saving File...")
        self.frameSaveAs.setGeometry(0, 40, 0, 480)
        try:
            self.core.current.image.save(self.btnSaveAsFilenameString().replace("JPEG", "jpg"), str(self.btnSaveAs_Combo.currentText()))
        except IOError:
            WaitOverlayOk(self,"Error: Could Not Write File")
        except:
            WaitOverlayOk(self,"Error: Failed to Save")
        finally:
            WaitOverlayOk(self,"Save Completed")
        
        
        
    def btnSaveAsFilenameString(self):
        return str(self.btnSaveAs_Location.text())+"/"+str(self.btnSaveAs_Filename.text())+"."+str(self.btnSaveAs_Combo.currentText())
        
    def btnSaveAsfindFileExists(self):
        if os.path.isfile(self.btnSaveAsFilenameString()):
            self.btnSaveAsGo.setEnabled(False)
        else:
            self.btnSaveAsGo.setEnabled(True)
            
    def btnSaveAsGenFilename(self, Dir, File):
        i=1
        while os.path.isfile(Dir+File+"_"+str(i)):
            i +=1
        return i
        
    def on_btnSaveAs_Combo_editTextChanged(self, p0):
        self.btnSaveAsfindFileExists()
        
    def on_btnSaveAs_Location_textChanged(self, p0):
        self.btnSaveAsfindFileExists()
        
    def on_btnSaveAs_Filename_textChanged(self, p0):
        self.btnSaveAsfindFileExists()
    
    def on_btnSaveAsCancelOut_pressed(self):
        self.frameSaveAs.setGeometry(0, 40, 0, 480)
        
    def on_btnSaveAsMore_pressed(self):
        if (str(self.btnSaveAsMore.text()) == "More"):
            self.btnSaveAsMore.setText("Less")
            self.frameSaveAuto.setVisible(False)
            self.frameSaveAvd.setVisible(True)
        else:
            self.btnSaveAsMore.setText("More")
            self.frameSaveAvd.setVisible(False)
            self.frameSaveAuto.setVisible(True)


    def on_btnPopWaitOk_pressed(self):
        WaitOverlayHide(self,)
        
    def on_btnApplyUndo_pressed(self):
        FullScreenToggle(self,True,  1)
    
    def on_btnEdit_pressed(self):
        AnimateWidget(self, self.photoListZoom, 40, 0, 0, 0, 10)
        LoadCurImageFromPhotoBrowser(self)
    
    def on_btnRefreshExp_pressed(self):
        if (str(self.btnRefreshExp.text()) =="+"):
            self.btnRefreshExp.setText("-")
            self.btnReloadPList.setGeometry(QtCore.QRect(400, 370, 111, 51))
            self.btnOpen.setGeometry(QtCore.QRect(510, 370, 111, 51))
            self.btnRefresh.setGeometry(QtCore.QRect(250, 370, 151, 51))
        else:
            self.btnRefreshExp.setText("+")
            self.btnReloadPList.setGeometry(QtCore.QRect(400, 370, 111, 0))
            self.btnOpen.setGeometry(QtCore.QRect(510, 370, 111, 0))
            self.btnRefresh.setGeometry(QtCore.QRect(250, 370, 151, 0))
    
    def on_btnPopMinimize_pressed(self):
        ui.showMinimized()
    
    def on_SearchPhoto_Mcc_toggled(self, checked):
        if (checked):
           SetConfig_SearchSettings(self, 1)
        else:
            SetConfig_SearchSettings(self, 0)
    
    @pyqtSignature("")
    def on_btnSaveSettings_pressed(self):
        WriteConfig(self)
