# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Standard Manupilation modules that are not directly UI based.
"""
import math
from PIL import Image
from core.core import *
from PIL import ImageDraw
from PIL import ImageEnhance
from PyQt4 import QtCore as QtCore
from PyQt4 import QtGui as QtGui 
from filters.toolbox import pil2qpixmap
from PyQt4.QtCore import pyqtSignature

#     out = im.transpose(Image.FLIP_LEFT_RIGHT)
#     out = im.transpose(Image.FLIP_TOP_BOTTOM)
#     out = im.transpose(Image.ROTATE_90)
#     out = im.transpose(Image.ROTATE_180)
#     out = im.transpose(Image.ROTATE_270)

### GUI Function Calls 


### NON-GUI Function Calls 

def RotateCalc(self, rotation, im):
    w, h = im.size
    theta =math.radians(rotation)

    botOps = round(abs(h * math.sin(theta))/2)
    botAdj = round(abs(h * math.cos(theta))/2)

    topOps = round(abs(w * math.sin(theta))/2)
    topAdj = round(abs(w * math.cos(theta))/2)

    theta = theta + math.pi/4
    if theta >= 6.28:
        theta = theta - 6.28
    pi2 = math.pi/2

    if( theta >= 0.0 and theta < pi2 ): #0 - 1.57 
        return([botOps,botOps, int(w-botOps),  int(h-botOps)]) 
    elif( theta >= pi2 and theta < math.pi): # 1.57 - 3.14
        return([botOps, botAdj, int(w-botOps),  int(h-botAdj)]) 
    elif( theta >= math.pi and theta < (math.pi + pi2) ): # 3.14 - 4.71
        return([botOps, botOps, int(w-botOps),  int(h-botOps)]) 
    elif( theta >= (math.pi + pi2)):  # 4.71 - 6.28 ok 
        return([botOps, botAdj, int(w-botOps),  int(h-botAdj)]) 


@pyqtSignature("int")
def RotateThumb(self, rotation):
    self.showUpdateLabel(True,  True)
    im=self.core.current.thumb
    
    im = im.rotate(rotation,  resample=Image.BICUBIC,  expand=0)
    draw = ImageDraw.Draw(im)
    draw.rectangle(RotateCalc(self, rotation, im))
    
    del draw
    self.photo_Thumb.setPixmap(pil2qpixmap(im))
    self.showUpdateLabel(False,  True)
    

@pyqtSignature("int")    
def RotateApply(self, rotation):
    if  (self.core.lockUpdating == False):
        self.showUpdateLabel(True,  False)
        im=self.core.current.image
        im = im.rotate(rotation,  resample=Image.BICUBIC,  expand=0)
        w1, h1, w2, h2 = RotateCalc(self,  rotation, im)
        
        self.core.current.image = im.crop((w1, h1, w2, h2))

        self.showUpdateLabel(False,  False)
        self.core.lockUpdating = False


@pyqtSignature("int,Bool,Bool")
def FlipThumb(self):
    self.showUpdateLabel(True,  True)
    im=self.core.current.thumb
    
    if self.core.flipRight:
        im = im.transpose(Image.FLIP_LEFT_RIGHT) 
    if self.core.flipBottom:
        im = im.transpose(Image.FLIP_UP_DOWN) 
        
    self.photo_Thumb.setPixmap(pil2qpixmap(im))
    self.showUpdateLabel(False,  True)
    
