# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Module implementing MainWindow.
"""
import math
import sys
import EXIF
import operator
import os
from PIL import Image, ImageEnhance, ImageDraw

from PyQt4 import QtGui
from PyQt4 import QtCore 
from PyQt4.QtGui import QMainWindow
from PyQt4.QtCore import pyqtSignature
from Ui_mainWindow import Ui_MainWindow


def Enhance(self, im, name, lo, hi):
# set up the image
    im=curIm
    self.enhancer = enhancer(im)
    self.update("1.0") # normalize

    self.value = eval(value)
    
def MinMax():
    if (self.isFullScreen):
        self.showFullScreen()
    else:
        self.showNormal()

def pil2qpixmap(pil_image):
    w, h = pil_image.size
    data = pil_image.tostring("raw", "BGRX")
    qimage = QtGui.QImage(data, w, h, QtGui.QImage.Format_RGB32)
    qpixmap = QtGui.QPixmap(w,h)
    pix = QtGui.QPixmap.fromImage(qimage)
    return pix

def valToScalar(value): #, soft):
    """
    Calculates an appropiate value to scale from / to
    """
#    if (soft == True):
#        if (value >0):
#            return 1+(math.exp(2-((99-value)*6/100)))
#        if (value <0):
#            return 1-((math.exp(2-((99+value)*6/100)))/8)
#        if (value ==0):
#            return 1
#    else:
    if (value >0):
        return 1+value/20.0
    if (value <0):
        return 1+(value*0.01)
    if (value ==0):
        return 1

class MainWindow(QMainWindow, Ui_MainWindow):
    """
    Main Window Class for AnselA
    """
    valR = 0
    valB = 0
    valG = 0
    valSa = 0
    valBr = 0
    valCo = 0
    valHi =0
    valMi =0
    valSh =0
    valSa =0
    valRot = 0
    valOrient = 0
    valBW = "L"
    wMaximized = True
    lockUpdating = False
    curImageLoc ="/opt/anselA/ui/resources/landscapeRepo.jpg"
    plotIm = Image.open("/opt/anselA/ui/resources/graph.png") 
    curIm =""
    curThumb = ""
    valCurTab=0
        
    def __init__(self, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.ImageOpen(self.curImageLoc)
        self.postSetup()
        self.ImageDisplayRefresh()
    
    def postSetup(self):
        self.tabStrip.setCurrentIndex(0)
        
    def showUpdateLabel(self, show,  thumb):
        self.lockUpdating = show
        if (thumb == True):
            if (show == True):
                self.labWaitThumb.setGeometry(QtCore.QRect(30, 120, 251, 161))
            else:
                self.labWaitThumb.setGeometry(QtCore.QRect(30, 120, 0, 161))
        else:
            if (show == True):
                self.tabPhoto.setCurrentIndex(1)
                self.labWait.setGeometry(QtCore.QRect(0, 0, 800, 441))
            else:
                self.tabPhoto.setCurrentIndex(0)
                self.labWait.setGeometry(QtCore.QRect(0, 0, 0, 441))
        self.labWait.repaint()
        self.repaint()

    
    @pyqtSignature("")
    def on_btn_Grey_released(self):
        """
        Slot documentation goes here.
        """
        self.valBW = "L"
        self.BWApply(self.curThumb,  self.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Red_released(self):
        """
        Slot documentation goes here.
        """
        self.valBW = "R"
        self.BWApply(self.curThumb,  self.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Green_released(self):
        """
        Slot documentation goes here.
        """
        self.valBW = "G"
        self.BWApply(self.curThumb,  self.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Blue_released(self):
        """
        Slot documentation goes here.
        """
        self.valBW = "B"
        self.BWApply(self.curThumb,  self.valBW,  False)
 
    @pyqtSignature("")
    def on_btn_Yellow_released(self):
        """
        Slot documentation goes here.
        """
        self.valBW = "Y"
        self.BWApply(self.curThumb,  self.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Cyan_released(self):
        """
        Slot documentation goes here.
        """
        self.valBW = "C"
        self.BWApply(self.curThumb,  self.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Magenta_released(self):
        """
        Slot documentation goes here.
        """
        self.valBW = "M"
        self.BWApply(self.curThumb,  self.valBW,  False)


    @pyqtSignature("")
    def on_btnLevelApply_released(self):
        """
        Slot documentation goes here.
        """
        if (self.valCurTab == 5):
            self.RotateApply(self.valRot)
        elif (self.valCurTab == 1):
            self.BWApply(self.curIm, self.valBW,  True)
        else:
            self.LevelApply(self.curIm,  True)           
    
    
    @pyqtSignature("")
    def BWApply(self, imageToEdit,  cSource,  UpdateRealImage):
        """
        Slot documentation goes here.
        """
        if  (self.lockUpdating == False):
            if (UpdateRealImage == True):
                self.showUpdateLabel(True,  False)
            else:
                self.showUpdateLabel(True,  True)
                
            im = imageToEdit
            source = im.split()
            R, G, B = 0, 1, 2
            imCMYK=im.convert("CMYK")
            C, M, Y, K = imCMYK.split()
            N =  Image.new('L', im.size, (0))
            
            
            if cSource == "R":
                out0=source[R].point(lambda i: i * 3)
                source[R].paste(out0,  None,  None)
                out1=source[G].point(lambda i: i * 0)
                source[G].paste(out1,  None,  None)
                out2=source[B].point(lambda i: i * 0)
                source[B].paste(out2,  None,  None)
                im=Image.merge("RGB", (out0 ,  source[G],  source[B] ))
                im=im.convert("L")
            elif cSource == "G":
                out=source[R].point(lambda i: i * 1)
                source[R].paste(out,  None,  None)
                out=source[G].point(lambda i: i * 1.9)
                source[G].paste(out,  None,  None)
                out=source[B].point(lambda i: i * 1)
                source[B].paste(out,  None,  None)
                im=Image.merge("RGB", (source[R] ,  source[G],  source[B] ))
                im=im.convert("L")
            elif cSource == "B":
                #source[B].point(lambda i: i * 1.2)
                im = source[R].convert("L")
            elif cSource == "C":
                source[B].point(lambda i: i * 1.2)
                source[G].point(lambda i: i * 1.2)
                out = Image.merge("RGB", (N, source[G],  source[B]) )
                im = out.convert("L")
            elif cSource == "BC":
                out = Image.merge("RGB", (N, source[G],  source[B]) )
                im = out.convert("L")
            elif cSource == "BM":
                source[R].point(lambda i: i +source[G].getpixel((0,0)) * .33)
                source[B].point(lambda i: i +source[G].getpixel((0,0)) * .66)
                out = Image.merge("RGB", (source[R], N,  source[B]) )
                im = out.convert("L")
            elif cSource == "M":
                source[R].point(lambda i: i +source[G].getpixel((0,0)) * .5)
                source[B].point(lambda i: i +source[G].getpixel((0,0)) * .5)
                out = Image.merge("RGB", (source[R], N,  source[B])  )
                im = out.convert("L")
            elif cSource == "RM":
                source[R].point(lambda i: i +source[G].getpixel((0,0)) * .33)
                source[B].point(lambda i: i +source[G].getpixel((0,0)) * .66)
                out = Image.merge("RGB", (source[R], N,  source[B])  )
                im = out.convert("L")
            elif cSource == "RY":
                out = Image.merge("RGB", (source[R], source[G],  N) )
                im = out.convert("L")
            elif cSource == "Y":
                source[R].point(lambda i: i * 1.66)
                source[G].point(lambda i: i * 1.66)
                out = Image.merge("RGB", (source[R], source[G],  N) )
                im = out.convert("L")
            elif cSource == "GY":
                out = Image.merge("RGB", (source[R], source[G],  N) )
                im = out.convert("L")                
            elif cSource == "GC":
                out = Image.merge("RGB", (N, source[G],  source[B]) )
                im = out.convert("L")    
            
            im = im.convert("RGB")

            
            if (UpdateRealImage == True):
                self.photo.setPixmap(pil2qpixmap(im))
                self.showUpdateLabel(False,  False)
            else:
                self.photo_Thumb.setPixmap(pil2qpixmap(im))
                self.showUpdateLabel(False,  True)
    
    @pyqtSignature("")
    def LevelApply(self, imageToEdit,  UpdateRealImage):
        """
        Slot documentation goes here.
        """
        if  (self.lockUpdating == False):
            if (UpdateRealImage == True):
                self.showUpdateLabel(True,  False)
            else:
                self.showUpdateLabel(True,  True)
                
            im = imageToEdit
            source = im.split()
            R, G, B = 0, 1, 2

            out = source[R].point(lambda i: i *valToScalar(self.valR))
            source[R].paste(out, None, None)

            out = source[G].point(lambda i: i *valToScalar(self.valG))
            source[G].paste(out, None, None)

            out = source[B].point(lambda i: i *valToScalar(self.valB))
            source[B].paste(out, None, None)
            
            im = Image.merge(im.mode, source)
            
            if (UpdateRealImage == True):
                self.photo.setPixmap(pil2qpixmap(im))
                self.showUpdateLabel(False,  False)
            else:
                self.photo_Thumb.setPixmap(pil2qpixmap(im))
                self.showUpdateLabel(False,  True)
    
    @pyqtSignature("int")
    def on_cSlide_B_valueChanged(self, value):
        """ 
        Slot documentation goes here.
        """
        self.valB = value
        self.lcdB.setText(str(self.valB))
        self.LevelApply(self.curThumb,  False)
    
    @pyqtSignature("int")
    def on_cSlide_R_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valR = value
        self.lcdR.setText(str(self.valR))
        self.LevelApply(self.curThumb,  False)
    
    @pyqtSignature("int")
    def on_cSlide_G_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valG = value
        self.lcdG.setText(str(self.valG))
        self.LevelApply(self.curThumb,  False)
    
    @pyqtSignature("")
    def on_btnLevelReset_released(self):
        """
        Slot documentation goes here.
        """
        self.cSlide_R.setValue(0)
        self.cSlide_G.setValue(0)
        self.cSlide_B.setValue(0)
        self.LevelApply(self.curThumb,  False)
        self.LevelApply(self.curIm,  True)
    
    @pyqtSignature("")
    def on_minMax_released(self):
        """
        Slot documentation goes here.
        """
        MinMax()

    def on_photo_released(self):
        """
        Slot documentation goes here.
        """
        QMessageBox.information(self, "Loading Data", "Please wait while the data is retrieved...")

    @pyqtSignature("int")
    def on_tabStrip_currentChanged(self, index):
        """
        Slot documentation goes here.
        """
        if (index==9):
            self.frameExitRequest.setGeometry(QtCore.QRect(0, 0, 800, 480))
        elif  (index==6):
            self.ReturnHistPlots()
        elif (index==8):
            self.AnimateTab()
        else:
            self.valCurTab = index
        

    @pyqtSignature("")
    def on_btnLevelReset2_released(self):
        """
        Slot documentation goes here.
        """
        self.cSlide_Sat.setValue(0)
        self.cSlide_Contrast.setValue(0)
        self.cSlide_Bright.setValue(0)
    
    @pyqtSignature("")
    def on_btnLevelApply2_released(self):
        """
        Slot documentation goes here.
        """
        if  (self.lockUpdating == False):
            self.showUpdateLabel(True)
            im = self.curIm
            enhancer = ImageEnhance.Brightness(im)
            bright_im = enhancer.enhance(self.valL*-1*0.01) #any value you want
            self.photo.setPixmap(pil2qpixmap(bright_im))
            self.showUpdateLabel(False)
    
    @pyqtSignature("")
    def on_btnOpen_released(self):
        """
        Key Press to launch File open dialog, store image and display on GUI
        """
        ImgTemp= str(QtGui.QFileDialog.getOpenFileName(self, 'Open File', '/home/user/MyDocs/DCIM/', ("Images (*.png *.jpg)")))
        if ImgTemp != "":
            self.curImageLoc = ImgTemp
        self.ImageOpen(self.curImageLoc)
        self.ImageDisplayRefresh()
        
    def ImageDisplayRefresh(self):
        """
        Display image on GUI
        """
        self.ImageLoad(self.curIm)
        self.photo.setPixmap(pil2qpixmap(self.curIm))
        self.photo_Orig.setPixmap(pil2qpixmap(self.curIm))
        self.photo_Thumb.setPixmap(pil2qpixmap(self.curThumb))
    
    def ImageOpen(self, filename):
        """
        Open File and poulate class parameters of Image.
        """
        self.curIm = Image.open(filename)
        
        p = open(filename, "rb")
        tags = EXIF.process_file(p)
        for key in tags.keys():
            try:
                newItem = str("%s: %s" %(key, tags[key]))
                
                if key == "Image Orientation":
                    if newItem == "Image Orientation: Horizontal (normal)":
                        self.valOrient = 0
                    else:
                        self.valOrient = 1
                    
                if (newItem !="" and  newItem.startswith("Maker Note") == False  and  newItem.startswith("MakerNote") == False  and  newItem.startswith("EXIF") == False):
                    self.listEXIFData.addItem(newItem)
                    self.listView
            except Exception, e:
                continue
                #print "EXIF Error"
      
        self.ImageLoad(self.curIm)
      
    def convertImSize(self, origW,  origH,  dConstraint):
        if (self.valOrient == 0): #landscape
            scale=origW/dConstraint
            newW=dConstraint
            newH=int(math.ceil(origH/scale))
        else: # portrait
            scale=origH/dConstraint
            newH=dConstraint
            newW=int(math.ceil(origW/scale))
            
        return newW,  newH
        
    def ImageLoad(self, im):
        
        self.curIm = im
        w, h = self.curIm.size
        #155, 195 is thumb center
        wTh,  hTh = self.convertImSize(w, h,  250)
        
        self.photo_Thumb.setGeometry(QtCore.QRect(155-int(wTh/2), 195-int(hTh/2), wTh, hTh))
        
        size = (wTh,  hTh )
        self.curThumb = im.resize(size, Image.ANTIALIAS)
        #self.curThumb.thumbnail(size, Image.ANTIALIAS)
        # resize makes a copy thumbnail modifies
        #self.ImageDisplayOrig()


    @pyqtSignature("int")
    def on_tabPhoto_currentChanged(self, index):
        """
        Slot documentation goes here.
        """
        if (index == 0):
            self.FullScreenToggle(False)
        else:
            self.FullScreenToggle(True)

#+++++++++++++++++++++++ END of Class    
    

    @pyqtSignature("int")
    def on_cSlide_Hi_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valHi = value
        self.lcdHi.setText(str(self.valHi))
    
    @pyqtSignature("int")
    def on_cSlide_Mi_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valMi = value
        self.lcdMi.setText(str(self.valMi))
    
    @pyqtSignature("int")
    def on_cSlide_Sh_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valSh = value
        self.lcdSh.setText(str(self.valSh))
    
    @pyqtSignature("int")
    def on_cSlide_Sa_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valSa = value
        self.lcdSa.setText(str(self.valSa))
        
    @pyqtSignature("int")
    def on_cSlide_Sw_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valSw = value
        self.lcdSw.setText(str(self.valSw))
    
    @pyqtSignature("int")
    def on_cSlide_Co_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valCo = value
        self.lcdCo.setText(str(self.valCo))
    
    @pyqtSignature("int")
    def on_cSlide_Br_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valBr = value
        self.lcdBr.setText(str(self.valBr))
    
    @pyqtSignature("int")
    def on_dial_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        if  (self.lockUpdating == False):
            self.valRot = value
            self.lcdRot_1.setText(str(self.valRot))
            self.RotateThumb(value)
           

    def RotateThumb(self, rotation):
        self.showUpdateLabel(True,  True)
        im=self.curThumb
        
        im = im.rotate(rotation,  resample=Image.BICUBIC,  expand=0)
        draw = ImageDraw.Draw(im)
        draw.rectangle(self.RotateCalc(rotation, im))
        
        del draw
        self.photo_Thumb.setPixmap(pil2qpixmap(im))
        self.showUpdateLabel(False,  True)
        
    def RotateApply(self, rotation):
        self.showUpdateLabel(True,  False)
        im=self.curIm
        im = im.rotate(rotation,  resample=Image.BICUBIC,  expand=0)
        w1, h1, w2, h2 = self.RotateCalc(rotation, im)
        
        self.curIm = im.crop((w1, h1, w2, h2))
        self.ImageDisplayRefresh()
        self.showUpdateLabel(False,  False)
        
    def RotateCalc(self, rotation,  im):

        w,  h = im.size
        theta =math.radians(rotation)

        botOps = round(abs(h * math.sin(theta))/2)
        botAdj = round(abs(h * math.cos(theta))/2)

        topOps = round(abs(w * math.sin(theta))/2)
        topAdj = round(abs(w * math.cos(theta))/2)
        
        theta = theta + math.pi/4
        if theta >= 6.28:
            theta = theta - 6.28
        pi2 = math.pi/2
        
        if( theta >= 0.0 and theta < pi2 ): #0 - 1.57 
            return([botOps,botOps, int(w-botOps),  int(h-botOps)]) 
        elif( theta >= pi2 and theta < math.pi): # 1.57 - 3.14
            return([botOps, botAdj, int(w-botOps),  int(h-botAdj)]) 
        elif( theta >= math.pi and theta < (math.pi + pi2) ): # 3.14 - 4.71
            return([botOps, botOps, int(w-botOps),  int(h-botOps)]) 
        elif( theta >= (math.pi + pi2)):  # 4.71 - 6.28 ok 
            return([botOps, botAdj, int(w-botOps),  int(h-botAdj)]) 


    @pyqtSignature("")
    def on_btnExitCancel_released(self):
        self.tabStrip.setCurrentIndex(self.valCurTab)
        self.frameExitRequest.setGeometry(QtCore.QRect(0, 0, 0, 0))
        
    @pyqtSignature("")
    def on_btnExitGo_released(self):
        sys.exit()
    
    @pyqtSignature("")
    def on_btn_rot_none_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("")
    def on_btn_rot_Vert_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("")
    def on_btn_rot_90cw_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("")
    def on_btn_rot_90ccw_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("")
    def on_btn_rot_Horz_pressed(self):
        """
        Slot documentation goes here.
        """
        
        #out = im.transpose(Image.FLIP_LEFT_RIGHT)
        #out = im.transpose(Image.FLIP_TOP_BOTTOM)
        #out = im.transpose(Image.ROTATE_90)
        #out = im.transpose(Image.ROTATE_180)
        #out = im.transpose(Image.ROTATE_270)

    
    @pyqtSignature("")
    def on_btn_rot_180_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("")
    def on_btnFullScreen_released(self):
        """
        Slot documentation goes here.
        """
        self.FullScreenToggle(True)
    
    @pyqtSignature("")
    def on_btnFullScreenClose_released(self):
        """
        Slot documentation goes here.
        """
        self.FullScreenToggle(False)

    @pyqtSignature("")
    def FullScreenToggle(self,  Show):
        """
        Slot documentation goes here.
        """
        if (Show):
            self.tabPhoto.setCurrentIndex(1)
            self.tabPhoto.setGeometry(QtCore.QRect(0, 40, 800, 480))    
            self.tabStrip.setGeometry(QtCore.QRect(190, 120, 691, 491))
        else:
            self.tabPhoto.setGeometry(QtCore.QRect(0, 0, 0, 0))
            self.tabStrip.setGeometry(QtCore.QRect(190, 40, 691, 491))
            self.photo.repaint()
            self.photo_Orig.repaint()
            
        self.tabPhoto.repaint()
        self.tabStrip.repaint()
        self.repaint()
    
    @pyqtSignature("")
    def on_btn_BC_released(self):
        """
        Slot documentation goes here.
        """
        self.valBW = "BC"
        self.BWApply(self.curThumb,  self.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_GC_released(self):
        """
        Slot documentation goes here.
        """
        self.valBW = "GC"
        self.BWApply(self.curThumb,  self.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_GY_released(self):
        """
        Slot documentation goes here.
        """
        self.valBW = "GY"
        self.BWApply(self.curThumb,  self.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_BM_released(self):
        """
        Slot documentation goes here.
        """
        self.valBW = "BM"
        self.BWApply(self.curThumb,  self.valBW,  False)
        
    @pyqtSignature("")
    def on_btn_RM_released(self):
        """
        Slot documentation goes here.
        """
        self.valBW = "RM"
        self.BWApply(self.curThumb,  self.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_RY_released(self):
        """
        Slot documentation goes here.
        """
        self.valBW = "RY"
        self.BWApply(self.curThumb,  self.valBW,  False)

    @pyqtSignature("")
    def ReturnHistPlots(self):
        """
        Slot documentation goes here.
        """
        histo=self.curIm.histogram()
        OrignX=37
        OrignY=108

        ScaleMax=(max(histo)/100)  #256)
        print ScaleMax

        plotList =list()
        valX=0

        for valY in histo:
            ProcVal =int(valY/ScaleMax)
            plotList.append(ProcVal)
    
        plotR = Image.new("RGB", self.plotIm.size)
        plotG = Image.new("RGB", self.plotIm.size)
        plotB = Image.new("RGB", self.plotIm.size)
        
        plotR.paste(self.plotIm)# = self.poltIm.copy()
        plotG.paste(self.plotIm)
        plotB.paste(self.plotIm)
        
        drawR = ImageDraw.Draw(plotR)
        drawG = ImageDraw.Draw(plotG)
        drawB = ImageDraw.Draw(plotB)        

        valX=0
        sortCol = list()
        for x in range(255):
            plotX =OrignX + x
            drawR.line([plotX, OrignY, plotX, OrignY-plotList[x]], fill="red")
            drawG.line([plotX, OrignY, plotX, OrignY-plotList[x+256]], fill="green")
            drawB.line([plotX, OrignY, plotX, OrignY-plotList[x+512]], fill="blue")
        del drawR
        del drawG
        del drawB

        #return plotIm
        
        self.graphRed.setPixmap(pil2qpixmap(plotR.convert("RGB")))
        self.graphGreen.setPixmap(pil2qpixmap(plotG.convert("RGB")))
        self.graphBlue.setPixmap(pil2qpixmap(plotB.convert("RGB")))
    
        
#        for x in range(255):
#            plotX =OrignX + x
#            sortCol=sorted(((x,plotList[x],"red"),(x+256,plotList[x+256],"green"),(x+512,plotList[x+512],"blue")), key=operator.itemgetter(1))
#            draw.line([plotX, OrignY, plotX, OrignY-sortCol[2][1]], fill=sortCol[2][2])
#            draw.line([plotX, OrignY, plotX, OrignY-sortCol[1][1]], fill=sortCol[1][2])
#            draw.line([plotX, OrignY, plotX, OrignY-sortCol[0][1]], fill=sortCol[0][2])
#        del draw 
