#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtCore/QSettings>

#include <QtGui/QMainWindow>
#include <QtGui/QMenuBar>

#include <QtSensors/QAccelerometer>

#ifdef Q_WS_MAEMO_5
#include <QtDBus/QtDBus>
#endif

// Neccessary for Qt Mobility API usage
QTM_USE_NAMESPACE

#include "ameterwidget.h"

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    // Note that this will only have an effect on Symbian and Fremantle.
    void setOrientation(ScreenOrientation orientation);

    void showExpanded();

public slots:
	void showAbout();
	void showSettings();
#ifdef Q_WS_MAEMO_5
	void screenChange(const QDBusMessage &message);
#endif

private:
	QAccelerometer *accelerometer;
	AMeterWidget *awidget;
#ifdef Q_WS_MAEMO_5
	QDBusInterface *dBusInterface;
#endif
};

#endif // MAINWINDOW_H

