#include "asettings.h"

extern qreal g_n;
extern qreal a_max;
extern int smoothing;
extern int angle_step;
extern int divisions;
extern int data_rate;

SettingsDialog::SettingsDialog(QWidget *parent): QDialog(parent)
{
	QHBoxLayout *hbox;
	QVBoxLayout *vbox;

	vbox = new QVBoxLayout();

	hbox = new QHBoxLayout();
	label = new QLabel(QString::fromUtf8("&g, m/s²"), this);
	hbox->addWidget(label);
	editG = new QLineEdit(this);
	hbox->addWidget(editG);
	editG->setInputMethodHints(Qt::ImhFormattedNumbersOnly);
	editG->setText(QString::number(g_n));
	label->setBuddy(editG);
	label = new QLabel(QString::fromUtf8("&Scale limit, g"), this);
	hbox->addWidget(label);
	editMax = new QLineEdit(this);
	hbox->addWidget(editMax);
	editMax->setInputMethodHints(Qt::ImhFormattedNumbersOnly);
	editMax->setText(QString::number(a_max));
	label->setBuddy(editMax);
	vbox->addLayout(hbox);
	
	hbox = new QHBoxLayout();
	label = new QLabel(QString::fromUtf8("g scale &divisions"), this);
	hbox->addWidget(label);
	editDiv = new QLineEdit(this);
	hbox->addWidget(editDiv);
	editDiv->setInputMethodHints(Qt::ImhDigitsOnly);
	editDiv->setText(QString::number(divisions));
	label->setBuddy(editDiv);
	vbox->addLayout(hbox);

	hbox = new QHBoxLayout();
	label = new QLabel(QString::fromUtf8("&Angle scale, °"), this);
	hbox->addWidget(label);
	editAngle = new QLineEdit(this);
	hbox->addWidget(editAngle);
	editAngle->setInputMethodHints(Qt::ImhDigitsOnly);
	editAngle->setText(QString::number(angle_step));
	label->setBuddy(editAngle);
	vbox->addLayout(hbox);

	hbox = new QHBoxLayout();
	label = new QLabel(QString::fromUtf8("Data &rate, Hz"), this);
	hbox->addWidget(label);
	editRate = new QLineEdit(this);
	hbox->addWidget(editRate);
	editRate->setInputMethodHints(Qt::ImhDigitsOnly);
	editRate->setText(QString::number(data_rate));
	label->setBuddy(editRate);
	label = new QLabel(QString::fromUtf8("&Smoothing"), this);
	hbox->addWidget(label);
	comboSmoothing = new QComboBox(this);
	comboSmoothing->addItem("None");
	comboSmoothing->addItem("Light");
	comboSmoothing->addItem("Medium");
	comboSmoothing->addItem("Strong");
	comboSmoothing->setCurrentIndex(smoothing);
	hbox->addWidget(comboSmoothing);
	label->setBuddy(comboSmoothing);
	vbox->addLayout(hbox);

	buttonOk = new QPushButton("Ok");
	vbox->addWidget(buttonOk);
	connect(buttonOk, SIGNAL(clicked()), this, SLOT(accept()));

	setLayout(vbox);

	layout()->setSizeConstraint(QLayout::SetFixedSize);
}

SettingsDialog::~SettingsDialog()
{
}

void SettingsDialog::accept()
{
	g_n = editG->text().toDouble();
	a_max = editMax->text().toDouble();
	smoothing = comboSmoothing->currentIndex();
	divisions = editDiv->text().toInt();
	angle_step = editAngle->text().toInt();
	data_rate = editRate->text().toInt();
	QDialog::accept();
}

