import Qt 4.7
import QtWebKit 1.0

Rectangle {
    id: rectangle1
    width: 800
    height: 440

    //////////////////////////////////////   startup function
    function startup()
    {
        if (mainApp.getdrivecity() !== null && mainApp.getdrivecity() !== " " && mainApp.getdrivecity() !== "") //1 line changed in 11.05.27
        {
            web_view1.city = mainApp.getdrivecity();
            js.city = mainApp.getdrivecity();
            console.log("startup... " + js.city + " , " + web_view1.city);
        }

    }
    Component.onCompleted:
    {
        rectangle1.startup();
    }//startup();

    //////////////////////////////////////   GPS timer
    Timer
    {
        id:timerUpdatepos
        interval: 10000; running: false; repeat: true; triggeredOnStart : true;
//        property real lat: 23.0
//        property real lon: 117.0
        onTriggered:
        {
//            timerUpdatepos.lat = mainApp.getlatitude();
//            timerUpdatepos.lon = mainApp.getlongtitude();
            //console.log(web_view1.lat + " , " + web_view1.lon);
            web_view1.setcenter();
        }
    }

    WebView {
        id: web_view1
        x: 0
        y: 0
        width: 800
        height: 440
        url: "drivemap.html"

        property string start: ""
        property string end: ""
        property string city: ""
        property string lat: "23.0"
        property string lon: "117.0"

        settings.javascriptEnabled : true
        settings.javaEnabled : true
        settings.pluginsEnabled : true
        settings.privateBrowsingEnabled : true
        settings.javascriptCanAccessClipboard : true
        settings.javascriptCanOpenWindows : true
        settings.localContentCanAccessRemoteUrls : true
        settings.offlineWebApplicationCacheEnabled : true

        pressGrabTime : 0

        onAlert: console.log(message)

        function setcenter ()
        {
            //console.log("setcenter");
            web_view1.lat = mainApp.getlatitude();
            web_view1.lon = mainApp.getlongtitude();
            console.log(web_view1.lat + " , " + web_view1.lon);
            evaluateJavaScript("map.panTo(new BMap.Point('"+ web_view1.lon + "', '"+ web_view1.lat + "'))");
        }

       function zoomIn() {
            evaluateJavaScript("map.zoomIn()");
             console.log("fuck..1....");
        }

       function zoomOut() {
            evaluateJavaScript("map.zoomOut()");
            console.log("fuck..2....");
        }

       function setCity(cityname)
       {
            //var aa = evaluateJavaScript("myGeo.getPoint('" + cityname + "', function(point){if (point) {map.centerAndZoom(point, 11);}}, '" + cityname + "');");

            //百度API v1.2的更新使上语句失效，改为下语句

            evaluateJavaScript("map.centerAndZoom('" + cityname + "');");
            mainApp.setDrivecity(cityname);
            //console.log(aa);
        }

       function getRoute()
       {
            evaluateJavaScript("driving.search('" + web_view1.start + "', '" + web_view1.end + "');");
            console.log("get route executed");
            //web_view1.html.search.
        }

        function search(addr)
        {
            evaluateJavaScript("local.search('" + addr + "');");
        }

       javaScriptWindowObjects: QtObject {
         id:js
         WebView.windowObjectName: "qml"
         property string route: ""
         property string city: "北京市"

         property string addr0: ""
         property string addr1: ""
         property string addr2: ""
         property string addr3: ""
         property string addr4: ""
         property string addr5: ""
         property string addr6: ""
         property string addr7: ""
         property string addr8: ""
         property string addr9: ""

        function qmlCall() {
             //console.log("fuck..qmlcall from html....");
            //web_view1.evaluateJavaScript("alert('This call is in QML! oh fuck!!!!!!!')");
             addressmodel.clear();
             addressmodel.append({"name" : js.addr0});
             addressmodel.append({"name" : js.addr1});
             addressmodel.append({"name" : js.addr2});
             addressmodel.append({"name" : js.addr3});
             addressmodel.append({"name" : js.addr4});
             addressmodel.append({"name" : js.addr5});
             addressmodel.append({"name" : js.addr6});
             addressmodel.append({"name" : js.addr7});
             addressmodel.append({"name" : js.addr8});
             addressmodel.append({"name" : js.addr9});

             listviewcontainer.y = 60;
           }

         function showroute()
         {
             //console.log(route);
             text_route.text = route;
             //flickable1.y = 55;
         }

       }
    }

    Image {
        id: imagecenter
        source: "center.png"
        anchors.centerIn: parent
    }

    ///////////////////////////////////////  city
    Item {
        id: item_city
        x: 22
        y: 244
        width: 80
        height: 58

        Image {
            id: image_citybg
            opacity: 0.7
            anchors.fill: parent
            source: "button-yellow.png"
        }

        Text {
            id: text1
            x: 28
            y: 22
            text: "城市"
            anchors.centerIn: parent
            font.bold: true
            font.pixelSize: 30
        }

        MouseArea
        {
            anchors.fill:parent
            onClicked:
            {
                rectangle_inputcity.x = 200;
            }
        }
    }

    ///////////////////////////////////////  zoom
    Item {
        id: item_zoom
        x: 22
        y: 366
        width: 160
        height: 68

        Image {
            id: image_zoombg
            opacity: 0.4
            anchors.fill: parent
            fillMode: Image.Stretch
            source: "button-white.png"
        }

        Image {
            id: image_zoomplus
            x: 102
            y: -94
            anchors.right: parent.right
            anchors.rightMargin: 0
            scale: 0.2
            source: "jia+.png"

            MouseArea
            {
                anchors.fill:parent
                onClicked:
                {
                    web_view1.zoomIn();
                    console.log("zoom in button clicked");
                }
            }
        }

        Image {
            id: image_zoomminus
            x: 96
            y: 10
            anchors.right: parent.right
            anchors.rightMargin: 9
            source: "minus.png"

            MouseArea
            {
                anchors.fill:parent
                onClicked:
                {
                    web_view1.zoomOut();
                    console.log("zoom out button clicked");
                }
            }
        }
    }

    ///////////////////////////////////////  start
    Item {
        id: item_start
        x: 658
        y: 126
        width: 120
        height: 60

        Image {
            id: image_startbg
            opacity: 0.5
            anchors.fill: parent
            source: "button-red.png"
        }

        Text {
            id: text_start
            x: 48
            y: 23
            text: "起点"
            anchors.centerIn: parent
            font.bold: true
            font.pixelSize: 30
        }

        MouseArea
        {
            anchors.fill:parent
            onClicked:
            {
                rectangle_inputstart.x = 200;
            }
        }
    }

    ///////////////////////////////////////  end
    Item {
        id: item_end
        x: 658
        y: 242
        width: 120
        height: 60

        Image {
            id: image_endbg
            opacity: 0.5
            anchors.fill: parent
            source: "button-red.png"
        }

        Text {
            id: text_end
            x: 48
            y: 23
            text: "终点"
            anchors.centerIn: parent
            font.bold: true
            font.pixelSize: 30
        }

        MouseArea
        {
            anchors.fill:parent
            onClicked:
            {
                rectangle_inputend.x = 200;
            }
        }
    }

    ///////////////////////////////////////  line
    Item {
        id: item_line
        x: 486
        y: 366
        width: 308
        height: 68

        Image {
            id: image_linebg
            opacity: 0.7
            anchors.fill: parent
            source: "button-lightblue.png"
        }

        Text {
            id: text4
            x: 10
            y: 10
            width: 80
            height: 20
            text: "获取"
            font.bold: true
            font.pixelSize: 42

            MouseArea
            {
                anchors.fill:parent
                onClicked:
                {
                    console.log("get route button clicked");
                    web_view1.getRoute();
                }
            }
        }

        Rectangle {
            id: rectangle4
            x: 102
            y: 5
            width: 18
            height: 58
            color: "#ffffff"
            opacity: 0.6
        }

        Text {
            id: text5
            x: 124
            y: 10
            width: 80
            height: 20
            text: "显示路线"
            font.bold: true
            font.pixelSize: 42

            MouseArea
            {
                anchors.fill:parent
                onClicked:
                {
                    console.log("show route button clicked");
                    //text_route = js.route;
                    flickable1.y = 55;
                }
            }
        }


    }

    ///////////////////////////////////////  inputstart
    Rectangle {
        id: rectangle_inputstart
        x: 800
        y: 106
        width: 420
        height: 100
        color: "#ffffff"
        radius: 8

        Behavior on x { NumberAnimation{} }

        Rectangle {
            id: rectangle2
            x: 14
            y: 10
            width: 82
            height: 80
            color: "#50f2f7"
            radius: 3

            Text {
                id: text2
                x: 8
                y: 22
                width: 80
                height: 20
                text: "取消"
                font.pixelSize: 30
            }

            MouseArea
            {
                anchors.fill:parent
                onClicked:
                {
                    rectangle_inputstart.x = 800;
                }
            }
        }

        Rectangle {
            id: rectangle3
            x: 332
            y: 10
            width: 76
            height: 80
            color: "#50f2f7"
            radius: 3

            Text {
                id: text3
                x: 5
                y: 22
                width: 80
                height: 20
                text: "确定"
                font.pixelSize: 30
            }

            MouseArea
            {
                anchors.fill:parent
                onClicked:
                {
                    rectangle_inputstart.x = 800;
                    listviewcontainer.inputState = "start";
                    console.log(text_edit_start.text);
                    web_view1.search(text_edit_start.text);
                    console.log("start input clicked");
                }
            }
        }

        TextEdit {
            id: text_edit_start
            x: 118
            y: 10
            width: 190
            height: 80
            text: "textEdit"
            horizontalAlignment: TextEdit.AlignHCenter
            verticalAlignment: TextEdit.AlignVCenter
            font.pixelSize: 30
        }
    }

    ///////////////////////////////////////  inputend
    Rectangle {
        id: rectangle_inputend
        x: 800
        y: 222
        width: 420
        height: 100
        color: "#ffffff"
        radius: 8

        Behavior on x { NumberAnimation{} }

        Rectangle {
            id: rectangle12
            x: 14
            y: 10
            width: 82
            height: 80
            color: "#50f2f7"
            radius: 3

            Text {
                id: text12
                x: 8
                y: 22
                width: 80
                height: 20
                text: "取消"
                font.pixelSize: 30
            }

            MouseArea
            {
                anchors.fill:parent
                onClicked:
                {
                    rectangle_inputend.x = 800;
                }
            }
        }

        Rectangle {
            id: rectangle13
            x: 332
            y: 10
            width: 76
            height: 80
            color: "#50f2f7"
            radius: 3

            Text {
                id: text13
                x: 5
                y: 22
                width: 80
                height: 20
                text: "确定"
                font.pixelSize: 30
            }

            MouseArea
            {
                anchors.fill:parent
                onClicked:
                {
                    rectangle_inputend.x = 800;
                    listviewcontainer.inputState = "end";
                    console.log(text_edit_end.text);
                    web_view1.search(text_edit_end.text);
                    console.log("end input clicked");
                }
            }
        }

        TextEdit {
            id: text_edit_end
            x: 118
            y: 10
            width: 190
            height: 80
            text: "textEdit"
            horizontalAlignment: TextEdit.AlignHCenter
            verticalAlignment: TextEdit.AlignVCenter
            font.pixelSize: 30
        }
    }

    ///////////////////////////////////////  inputcity
    Rectangle {
        id: rectangle_inputcity
        x: -420
        y: 222
        width: 420
        height: 100
        color: "#ffffff"
        radius: 8

        Behavior on x { NumberAnimation{} }

        Rectangle {
            id: rectangle22
            x: 14
            y: 10
            width: 82
            height: 80
            color: "#50f2f7"
            radius: 3

            Text {
                id: text22
                x: 8
                y: 22
                width: 80
                height: 20
                text: "取消"
                font.pixelSize: 30
            }

            MouseArea
            {
                anchors.fill:parent
                onClicked:
                {
                    rectangle_inputcity.x = -420;
                }
            }
        }

        Rectangle {
            id: rectangle23
            x: 332
            y: 10
            width: 76
            height: 80
            color: "#50f2f7"
            radius: 3

            Text {
                id: text23
                x: 5
                y: 22
                width: 80
                height: 20
                text: "确定"
                font.pixelSize: 30
            }

            MouseArea
            {
                anchors.fill:parent
                onClicked:
                {
                    rectangle_inputcity.x = -420;
                    web_view1.setCity(text_edit_city.text);
                    console.log("set city button clicked");
                }
            }
        }

        TextEdit {
            id: text_edit_city
            x: 118
            y: 10
            width: 190
            height: 80
            text: "textEdit"
            horizontalAlignment: TextEdit.AlignHCenter
            verticalAlignment: TextEdit.AlignVCenter
            font.pixelSize: 30
        }
    }

    ///////////////////////////////////////  GPS button
    Item {
        id: gps_button
        x: 20
        y: 130
        width: 84
        height: 84
        property bool firstuse: true

        Text {
            id: text_gps
            x: 0
            y: 15
            text: "GPS"
            anchors.centerIn: parent
            font.pixelSize: 40
        }

        Image {
            id: image_gps
            anchors.fill: parent
            opacity: 1
            source: "no.png"
        }

        MouseArea {
            id: gpsmouse_area
            anchors.fill: parent
            onClicked:
            {
                if (gps_button.firstuse)
                {
                    mainApp.useInfobox("请设置城市");
                    rectangle_inputcity.x = 200;
                    gps_button.firstuse = false;
                }
//                web_view1.setcenter();
                else if (timerUpdatepos.running == true)
                {
                    mainApp.gpsSwitch();
                    image_gps.opacity = 1;
                    timerUpdatepos.stop();
//                    timerUpdatepos.running = false;
//                    timerUpdatepos.repeat = false;
                }
                else if (timerUpdatepos.running == false)
                {
                    mainApp.gpsSwitch();
                    image_gps.opacity = 0;
                    timerUpdatepos.start();
//                    timerUpdatepos.running = true;
//                    timerUpdatepos.repeat = true;
                }
            }
        }
    }

    ///////////////////////////////////////  list view
    Item {
        id: listviewcontainer
        x:100
        y:440
        width: 500
        height: 300

        property string inputState: "null"

        ListModel
        {
            id:addressmodel
            ListElement { name:"null" }
        }

        Component
        {
            id:viewdelegate
            Rectangle
            {
                width:listviewcontainer.width
                height:childrenRect.height
                border.color: "lightsteelblue"
                radius:5

                Text {
                    width: parent.width - 10.0
                    text: name
                    font.bold: true
                    anchors.horizontalCenter: parent.horizontalCenter
                    wrapMode: Text.WrapAnywhere
                }

                MouseArea
                {
                    anchors.fill:parent
                    onClicked:
                    {
                        if (listviewcontainer.inputState == "start")
                        {
                            web_view1.start = name;
                            web_view1.start = web_view1.start.split(",")[0];
                            listviewcontainer.y = 440;
                            console.log(web_view1.start);
                            listviewcontainer.inputState = "null";
                        }
                        if (listviewcontainer.inputState == "end")
                        {
                            web_view1.end = name;
                            web_view1.end = web_view1.end.split(",")[0];
                            listviewcontainer.y = 440;
                            console.log(web_view1.end);
                            listviewcontainer.inputState = "null";
                        }
                    }
                }
            }
        }

        ListView
        {
            id:addressviewlist
            anchors.fill:parent
            model:addressmodel
            delegate:viewdelegate
        }

        Behavior on y
        {
            NumberAnimation {}
        }

    }

    ///////////////////////////////////////  show route area
    Flickable {
        id: flickable1
        x: 100
        y: -350
        width: 600
        height: 350
        clip: true
        contentHeight: rectangle_showroute.height
        contentWidth: rectangle_showroute.width

        Behavior on y { NumberAnimation{} }

        Rectangle {
            id: rectangle_showroute
            x: 0
            y: 0
            width: 600
            height: 999
            color: "#ffffff"
            clip: true

            Text {
                id: text_route
                x: 0
                y: 0
                width: 600
                height: 200
                text: "text"
                wrapMode: Text.WrapAtWordBoundaryOrAnywhere
                font.pixelSize: 20
            }


        }

        MouseArea
        {
//            width:400
//            height:300
//            anchors.centerIn:parent
            anchors.fill:parent
            onClicked:
            {
                flickable1.y = -350;
                console.log("show route clicked and exit");
            }
        }
    }

//    Timer {
//        id:timerGetgps
//             interval: 5000; running: true; repeat: true;
//             onTriggered:
//             {
//                 web_view1.lat = mainApp.getlatitude();
//                 web_view1.lon = mainApp.getlongtitude();
//                 console.log(web_view1.lat + " , " + web_view1.lon);
//             }
//         }


}
