// checksum 0xa193 version 0x30001
/*
  This file was generated by the Mobile Qt Application wizard of Qt Creator.
  MainWindow is a convenience class containing mobile device specific code
  such as screen orientation handling.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/
#include <QDeclarativeView>
#include <QDeclarativeContext>
#include <QtDebug>
#include <QNetworkAccessManager>
#include <QUrl>
#include <QNetworkReply>
#include <QtCore/QSettings>
#include <QtCore/QDir>
#include <QTextCodec>
#include <QTextStream>
#include <QTextBrowser>

#ifdef Q_WS_MAEMO_5
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include <QMenuBar>
#include <QMaemo5InformationBox>

#include <QGeoPositionInfoSource>
#include <QGeoCoordinate>
#endif

#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QtCore/QCoreApplication>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    this->setWindowTitle("AesyPig");
    menuBar = new QMenuBar(this);
    menuBar->setObjectName(QString::fromUtf8("menuBar"));
    this->setMenuBar(menuBar);
//    ui->setupUi(this);
    QAction *mainmenu = new QAction(tr("main menu"),this);
    QMainWindow::menuBar()->addAction(mainmenu);
    connect(mainmenu,SIGNAL(triggered()),this,SLOT(toMainmenu()));
    //////////////////////////////////////////////////////  initial qml viewer
    qmlView = new QDeclarativeView;
    QDeclarativeContext *context = qmlView->rootContext();
    context->setContextProperty("mainApp", this);
    qmlView->setSource(QUrl("qrc:/mainmenu.qml"));
    //qmlView->setSource(QUrl("qrc:/browser.qml"));
    this->setCentralWidget(qmlView);

    //////////////////////////////////////////////////////  load config
    this->loadConfig();

    //////////////////////////////////////////////////////  GPS
    this->gpsstat = true;
#ifdef Q_WS_MAEMO_5
    source = QGeoPositionInfoSource::createDefaultSource(this);
        if (source)
        {
            connect(source, SIGNAL(positionUpdated(QGeoPositionInfo)),this, SLOT(positionUpdated(QGeoPositionInfo)));
            source->setUpdateInterval(10000);
            source->startUpdates();
        }
#endif


        //////////////////////////////////////////////////////   network access manager
        manager = new QNetworkAccessManager(this);
        connect(manager, SIGNAL(finished(QNetworkReply*)),
                 this, SLOT(replyFinished(QNetworkReply*)));

#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(this,"Welcome!",QMaemo5InformationBox::DefaultTimeout);
#endif
}

void MainWindow::toMainmenu()
{
    this->qmlView->setSource(QUrl("qrc:/mainmenu.qml"));
    qDebug() << "outside the mainmenu if" ;
}

void MainWindow::toDrivemap()
{
    qmlView = new QDeclarativeView;
    QDeclarativeContext *context = qmlView->rootContext();
    context->setContextProperty("mainApp", this);
    qDebug() << "toDrivemap" ;
    this->qmlView->setSource(QUrl("qrc:/qdrivemap.qml"));
    this->setCentralWidget(qmlView);
    qDebug() << "toDrivemap" ;
}

void MainWindow::toBusmap()
{
    qmlView = new QDeclarativeView;
    QDeclarativeContext *context = qmlView->rootContext();
    context->setContextProperty("mainApp", this);
    qDebug() << "toBusmap" ;
    this->qmlView->setSource(QUrl("qrc:/browser.qml"));
    this->setCentralWidget(qmlView);
    qDebug() << "toBusmap" ;
}

void MainWindow::toOsmmap()
{

}

#ifdef Q_WS_MAEMO_5
void MainWindow::positionUpdated(const QGeoPositionInfo &info)
{
    this->m_latitude = info.coordinate().latitude();
    this->m_longitude = info.coordinate().longitude();
    QString urltemp("http://api.map.baidu.com/ag/coord/convert?from=0&to=4&x=%1&y=%2");
    QUrl baiduurl(urltemp.arg(this->m_longitude).arg(this->m_latitude));
    qDebug() << baiduurl ;
    manager->get(QNetworkRequest(baiduurl));
}
#endif

//////////////////////////////////////////////////////////////////   get & set
QString MainWindow::getlatitude()  const
{
    return this->lattitude;
}

QString MainWindow::getlongtitude()  const
{
    return this->longtitude;
}

QString MainWindow::getdrivecity()  const
{
    return this->drivecity;
}

QString MainWindow::getbuscity()  const
{
    return this->buscity;
}

void MainWindow::setDrivecity(QString city)
{
    this->drivecity = city;
}

void MainWindow::setBuscity(QString city)
{
    this->buscity = city;
}

void MainWindow::setDrivelocation(QString lat, QString lon)
{
    this->drivelat = lat;
    this->drivelon = lon;
}

void MainWindow::setBuslocation(QString lat, QString lon)
{
    this->buslat = lat;
    this->buslon = lon;
}
/////////////////////////////////////////////////////////////////////////////////

//qreal MainWindow::getlatitude()  const
//{
//    return this->m_latitude;
//}

//qreal MainWindow::getlongtitude()  const
//{
//    return this->m_longitude;
//}

void MainWindow::useInfobox(QString info)
{    
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(this, info ,QMaemo5InformationBox::DefaultTimeout);
#endif
}

void MainWindow::useBigInfobox(QString info)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox *box = new QMaemo5InformationBox(this);
             QTextBrowser *textBrowser = new QTextBrowser(box);
             textBrowser->setText(info);
             box->setWidget(textBrowser);
             box->setTimeout(QMaemo5InformationBox::NoTimeout);
             box->exec();
#endif
}

#ifdef Q_WS_MAEMO_5
void MainWindow::gpsSwitch()
{
    if (this->gpsstat == false)
    {
        //disconnect(source, SIGNAL(positionUpdated(QGeoPositionInfo)),this, SLOT(positionUpdated(QGeoPositionInfo)));
        this->source->stopUpdates();
        this->gpsstat = true;
    }
    else
    //if (this->gpsstat == false)
    {
        //connect(source, SIGNAL(positionUpdated(QGeoPositionInfo)),this, SLOT(positionUpdated(QGeoPositionInfo)));
        this->source->startUpdates();
        this->gpsstat = false;
    }
}
#endif

void MainWindow::replyFinished(QNetworkReply *reply)
{
    if (reply->error() == QNetworkReply::NoError)
    {
        QByteArray data = reply->readAll();
        QString latlong(data);
        qDebug() << latlong ;
        this->seperatelatlong(latlong);
    }
}

void MainWindow::seperatelatlong(QString poss)
{
    QStringList temp0 = poss.split(",");
    if (temp0.length() > 1)
    {
        //qDebug() << temp0 ;
        QStringList lon = temp0[1].split(":");
        QStringList lat = temp0[2].split(":");
        //qDebug() << lat ;
        //qDebug() << lon ;
        QString lon11 = lon[1].remove(QChar('"'), Qt::CaseInsensitive);
        QString lat11 = lat[1].remove(QChar('"'), Qt::CaseInsensitive).remove(QChar('}'), Qt::CaseInsensitive);
        qDebug() << lon11 ;
        qDebug() << lat11 ;
        QByteArray temp0base64 = lat11.toAscii();
        QString lattemp(QByteArray::fromBase64(temp0base64));
        qDebug() << lattemp ;
        QByteArray temp1base64 = lon11.toAscii();
        QString lontemp(QByteArray::fromBase64(temp1base64));
        qDebug() << lontemp ;
        this->lattitude = lattemp;
        this->longtitude = lontemp;
    }
}

void MainWindow::saveConfig()
{
    QSettings set(QDir::homePath()+"/MyDocs/.aesypig/aesypig.ini", QSettings::IniFormat);
    set.setIniCodec("gb18030");
    set.beginGroup("address");
    set.setValue("drivelon", this->drivelon);
    set.setValue("drivelat", this->drivelat);
    set.setValue("drivecity", this->drivecity);
    qDebug() << this->drivecity;
    set.setValue("buslon", this->buslon);
    set.setValue("buslat", this->buslat);
    set.setValue("buscity", this->buscity);
    qDebug() << this->buscity;
    //set.setValue("usage", m_usage);
    set.endGroup();
}

void MainWindow::loadConfig()
{
    QSettings set(QDir::homePath()+"/MyDocs/.aesypig/aesypig.ini", QSettings::IniFormat);

    set.beginGroup("address");
    this->drivelon = set.value("drivelon", "116.0").toString();
    this->drivelat = set.value("drivelat", "23.0").toString();
    QByteArray tempcity = set.value("drivecity", "").toByteArray();
    QTextStream drivein(tempcity);
    drivein.setCodec("gb18030");
    this->drivecity = drivein.readAll();
    /////////////////////////////
    this->buslon = set.value("buslon", "116.0").toString();
    this->buslat = set.value("buslat", "23.0").toString();
    QByteArray tempbus = set.value("buscity", "").toByteArray();
    QTextStream busin(tempbus);
    busin.setCodec("gb18030");
    this->buscity = busin.readAll();
    //QTextCodec *codec = QTextCodec::codecForName("utf-16");
    //this->drivecity = codec->toUnicode(tempcity);
    //tempcity = this->drivecity.toUtf8();
    //this->drivecity = QString(tempcity);
    //qDebug() << " , " + this->drivelat + "," + this->drivelon;
    qDebug() << "setting read...........";
    //this->useInfobox(this->drivecity);
    set.endGroup();
}

MainWindow::~MainWindow()
{
//    delete ui;
    this->saveConfig();
}


void MainWindow::setOrientation(ScreenOrientation orientation)

{

//#if defined(Q_OS_SYMBIAN)
//    // If the version of Qt on the device is < 4.7.2, that attribute won't work
//    if (orientation != ScreenOrientationAuto) {
//        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
//        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
//            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");

//            return;
//        }
//    }
//#endif // Q_OS_SYMBIAN

//    Qt::WidgetAttribute attribute;
//    switch (orientation) {
//#if QT_VERSION < 0x040702
//    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
//    case ScreenOrientationLockPortrait:
//        attribute = static_cast<Qt::WidgetAttribute>(128);
//        break;
//    case ScreenOrientationLockLandscape:
//        attribute = static_cast<Qt::WidgetAttribute>(129);
//        break;
//    default:
//    case ScreenOrientationAuto:
//        attribute = static_cast<Qt::WidgetAttribute>(130);
//        break;
//#else // QT_VERSION < 0x040702
//    case ScreenOrientationLockPortrait:
//        attribute = Qt::WA_LockPortraitOrientation;
//        break;
//    case ScreenOrientationLockLandscape:
//        attribute = Qt::WA_LockLandscapeOrientation;
//        break;
//    default:
//    case ScreenOrientationAuto:
//        attribute = Qt::WA_AutoOrientation;
//        break;
//#endif // QT_VERSION < 0x040702
//    };
//    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
    showMaximized();
#else
    show();
#endif
}
