import Qt 4.7
import QtWebKit 1.0

Rectangle {
    id:main
    width: 800
    height: 440

    /////////////////////////////////// startup function
    function startup()
    {
        if (mainApp.getbuscity() !== null && mainApp.getbuscity() !== " " && mainApp.getbuscity() !== "")
        {
            webView.city = mainApp.getbuscity();
            js.city = mainApp.getbuscity();
            console.log("startup... " + js.city + " , " + webView.city);
        }

    }
    Component.onCompleted:
    {
        main.startup();
    }//startup();

    /////////////////////////////////// GPS timer
    Timer
    {
        id:timerUpdatepos
        interval: 10000; running: false; repeat: true; triggeredOnStart : true;

        onTriggered:
        {
            webView.setcenter();
        }
    }


    ///////////////////////////////////  main webview
    WebView {
        id: webView
	anchors.fill: parent

        property string start: ""
        property string end: ""
        property string city: ""
        property string lat: "23.0"
        property string lon: "117.0"
        //property string route: ""

	
	settings.javascriptEnabled : true
	settings.javaEnabled : true
	settings.pluginsEnabled : true
	settings.privateBrowsingEnabled : true
	settings.javascriptCanAccessClipboard : true
	settings.javascriptCanOpenWindows : true
	settings.localContentCanAccessRemoteUrls : true
	settings.offlineWebApplicationCacheEnabled : true

	pressGrabTime : 0
        
// 	url: "http://www.g.cn/"
        url: "routemap.html"

         onAlert: console.log("alert: " + message)

         function setcenter ()
         {
             //console.log("setcenter");
             webView.lat = mainApp.getlatitude();
             webView.lon = mainApp.getlongtitude();
             console.log(webView.lat + " , " + webView.lon);
             evaluateJavaScript("map.panTo(new BMap.Point('"+ webView.lon + "', '"+ webView.lat + "'))");
         }

	function zoomIn() {
             evaluateJavaScript("map.zoomIn()");
	      console.log("fuck..1....");
         }

	function zoomOut() {
             evaluateJavaScript("map.zoomOut()");
             console.log("fuck..2....");
         }

        function setCity(cityname)
        {
             //var aa = evaluateJavaScript("myGeo.getPoint('" + cityname + "', function(point){if (point) {map.centerAndZoom(point, 11);}}, '" + cityname + "');");

             //百度API v1.2的更新使上语句失效，改为下语句

             evaluateJavaScript("map.centerAndZoom('" + cityname + "');");
             mainApp.setBuscity(cityname);
             //evaluateJavaScript("map.setCenter('" + cityname + "');");
             //evaluateJavaScript("map.setCurrentCity('" + cityname + "');");
             //console.log(aa);
         }

        function getRoute()
        {
             evaluateJavaScript("transit.search('" + webView.start + "', '" + webView.end + "');");
             console.log(webView.start + "', '" + webView.end);
             console.log("get route executed");
             //webView.html.search.
         }

        function showRoute()
        {
             console.log(js.route);
             routeTextShow.text = js.route;
             routeArea.opacity = 1;
         }

         function search(addr)
         {
             evaluateJavaScript("local.search('" + addr + "');");
         }

        javaScriptWindowObjects: QtObject {
	  id:js
	  WebView.windowObjectName: "qml"
          property string route: ""
          property string city: "北京市"

          property string addr0: ""
          property string addr1: ""
          property string addr2: ""
          property string addr3: ""
          property string addr4: ""
          property string addr5: ""
          property string addr6: ""
          property string addr7: ""
          property string addr8: ""
          property string addr9: ""

          function searchsuccess()
          {
              console.log("search successful !");
              mainApp.useInfobox("路线搜索成功！");
          }

         function qmlCall() {
              console.log("fuck..qmlcall....");
             //webView.evaluateJavaScript("alert('This call is in QML! oh fuck!!!!!!!')");
              addressmodel.clear();
              addressmodel.append({"name" : js.addr0});
              addressmodel.append({"name" : js.addr1});
              addressmodel.append({"name" : js.addr2});
              addressmodel.append({"name" : js.addr3});
              addressmodel.append({"name" : js.addr4});
              addressmodel.append({"name" : js.addr5});
              addressmodel.append({"name" : js.addr6});
              addressmodel.append({"name" : js.addr7});
              addressmodel.append({"name" : js.addr8});
              addressmodel.append({"name" : js.addr9});

              listviewcontainer.y = 60;
            }
        }
        
        Image {
            id: zoomIn
            source: "jia+.png"
            scale: 0.2
            anchors { left: parent.left; bottom: parent.bottom; leftMargin: -70; bottomMargin: -80 }

            MouseArea
            {
                anchors.fill:parent
                onClicked:webView.zoomIn()
            }
        }

        Image {
            id: zoomOut
            source: "jian-.png"
            scale: 0.25
            anchors { left: parent.left; bottom: parent.bottom; leftMargin: 35; bottomMargin: -55 }

            MouseArea
            {
                anchors.fill:parent
                onClicked:webView.zoomOut()
            }
        }

    }

    /////////////////////////////  center image
    Image {
        id: imagecenter
        source: "center.png"
        anchors.centerIn: parent
    }

    /////////////////////////////  set city button
    Item
    {
        id:city
        width:100
        height:50
        //color: "#00b1ff"
        anchors { right:parent.right; top:parent.top; rightMargin:20; topMargin:20 }

        Image {
            id: cityimage
            source: "button-white.png"
            anchors.fill: parent
            opacity: 0.7
        }

        Text {
            id: cityText
            text: "城市"
            anchors.centerIn:parent
        }

        MouseArea
        {
            anchors.fill:parent
            onClicked:
            {
                console.log("city button");
                inputBox.opacity = 1;
                inputBox.x = 200;
                //buttonOK.opacity = 1
                inputBox.inputState = "city";
            }
        }

    }

    /////////////////////////////  set start button
    Item
    {
        id:start
        width:100
        height:50
        //color: "#00b1ff"
        anchors { right:parent.right; top:parent.top; rightMargin:20; topMargin:120 }

        Image {
            id: startimage
            source: "button-white.png"
            anchors.fill: parent
            opacity: 0.7
        }

        Text {
            id: startText
            text: "起点"
            anchors.centerIn:parent
        }

        MouseArea
        {
            anchors.fill:parent
            onClicked:
            {
                console.log("start button");
                //input.text = "五山";
                inputBox.opacity = 1;
                inputBox.x = 200;
                inputBox.inputState = "start";
            }
        }

    }

    /////////////////////////////  set end button
    Item
    {
        id:end
        width:100
        height:50
        //color: "#00b1ff"
        anchors { right:parent.right; top:parent.top; rightMargin:20; topMargin:220 }

        Image {
            id: endimage
            source: "button-white.png"
            anchors.fill: parent
            opacity: 0.7
        }

        Text {
            id: endText
            text: "终点"
            anchors.centerIn:parent
        }

        MouseArea
        {
            anchors.fill:parent
            onClicked:
            {
                console.log("end button");
                //input.text = "琶洲";
                inputBox.opacity = 1;
                inputBox.x = 200;
                inputBox.inputState = "end";
            }
        }

    }

    ///////////////////////////////////////  GPS button
    Item {
        id: gps_button
        x: 20
        y: 130
        width: 84
        height: 84
        property bool firstuse: true

        Text {
            id: text_gps
            x: 0
            y: 15
            text: "GPS"
            anchors.centerIn: parent
            font.pixelSize: 40
        }

        Image {
            id: image_gps
            anchors.fill: parent
            opacity: 1
            source: "no.png"
        }

        MouseArea {
            id: gpsmouse_area
            anchors.fill: parent
            onClicked:
            {
                if (gps_button.firstuse)
                {
                    mainApp.useInfobox("请设置城市");
                    inputBox.opacity = 1;
                    inputBox.x = 200;
                    inputBox.inputState = "city"
                    gps_button.firstuse = false;
                }
//                web_view1.setcenter();
                else if (timerUpdatepos.running == true)
                {
                    mainApp.gpsSwitch();
                    image_gps.opacity = 1;
                    timerUpdatepos.stop();

//                    timerUpdatepos.running = false;
//                    timerUpdatepos.repeat = false;
                }
                else if (timerUpdatepos.running == false)
                {
                    mainApp.gpsSwitch();
                    image_gps.opacity = 0;
                    timerUpdatepos.start();
//                    timerUpdatepos.running = true;
//                    timerUpdatepos.repeat = true;
                }
            }
        }
    }

    /////////////////////////////  input box
    Rectangle {
        id: inputBox
            x: 800
            width: input.width + buttonOK.width + buttoncancel.width + 20
            height: input.height + 4
//            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter: parent.verticalCenter
            radius: 5
            opacity: 0
            property string inputState: "null"

            Behavior on x { NumberAnimation{} }

            Rectangle
            {
                id:buttoncancel
                width:50
                height:input.height
                color:"#00b1ff"
                anchors { left:inputBox.left; top:input.top }

                Text
                {
                    text:"取消"
                    anchors.centerIn:parent
                }

                MouseArea
                {
                    anchors.fill:parent
                    onClicked:
                    {
                        console.log("input cancel pressed");
                        inputBox.x = 800;
                        inputBox.opacity = 0;
                        inputBox.inputState = "null";
                    }
                }
            }

            TextInput {
                id: input
                text: "input"
                horizontalAlignment: Text.AlignHCenter
                width: 220
                font.pointSize: 40
                anchors { horizontalCenter:inputBox.horizontalCenter; verticalCenter:inputBox.verticalCenter }
                Keys.onReturnPressed:
                {
                    console.log("input returned")
                    inputBox.opacity = 0
                }
            }

            Rectangle
            {
                id:buttonOK
                width:50
                height:input.height
                color:"#00b1ff"
                //opacity: 0
                anchors { right:inputBox.right; top:input.top }

                Text
                {
                    text:"确定"
                    anchors.centerIn:parent
                }

                MouseArea
                {
                    anchors.fill:parent
                    onClicked:
                    {
                        console.log("input OK pressed");
                        inputBox.opacity = 0;
                        inputBox.x = 800;
                        if (inputBox.inputState == "city")
                        {
                            webView.city = input.text;
                            console.log(webView.city);
                            webView.setCity(webView.city);
                            inputBox.inputState = "null";
                        }
                        if (inputBox.inputState == "start")
                        {
                            webView.search(input.text);
                            //webView.start = input.text;
                            //console.log(webView.start);
                            //inputBox.inputState = "null";
                        }
                        if (inputBox.inputState == "end")
                        {
                            webView.search(input.text);
//                            webView.end = input.text;
//                            console.log(webView.end);
//                            inputBox.inputState = "null";
                        }
                    }
                }
            }
    }

    /////////////////////////////  show route button
    Item
    {
        id:showroute
        width:120
        height:50
        //color: "#00b1ff"
        anchors { right:parent.right; bottom:parent.bottom; rightMargin:20; bottomMargin:20 }

        Image {
            id: shouRimage
            source: "button-lightblue.png"
            anchors.fill: parent
            opacity: 0.7
        }

        Text {
            id: showRouteText
            text: "显示路线"
            anchors.centerIn:parent
        }

        MouseArea
        {
            anchors.fill:parent
            onClicked:
            {
                console.log("show route button");
                webView.showRoute();
                //inputBox.opacity = 1;
                //inputBox.inputState = "end";
            }
        }

    }

    /////////////////////////////  get route button
    Item
    {
        id:getroute
        width:120
        height:50
        //color: "#00b1ff"
        anchors { right:parent.right; bottom:parent.bottom; rightMargin:200; bottomMargin:20 }

        Image {
            id: getRimage
            source: "button-lightblue.png"
            anchors.fill: parent
            opacity: 0.7
        }

        Text {
            id: getRouteText
            text: "找路线"
            anchors.centerIn:parent
        }

        MouseArea
        {
            anchors.fill:parent
            onClicked:
            {
                console.log("get route button");
                webView.getRoute();
                //inputBox.opacity = 1;
                //inputBox.inputState = "end";
            }
        }

    }

    /////////////////////////////  show route area
    Rectangle{
        id:routeArea
        width:800
        height:350
        radius: 5
        color:"#ffffff"
        opacity:0
        anchors.centerIn:parent

        Text {
            id: routeTextShow
            width:795
            height:345
            clip : true
            wrapMode : Text.Wrap
            text: ""
            anchors.centerIn:parent
        }

        MouseArea {
            anchors.fill:parent
            onClicked:routeArea.opacity = 0
        }

    }

    /////////////////////////////  list view
    Item {
        id: listviewcontainer
        x:100
        y:440
        width: 500
        height: 300

        ListModel
        {
            id:addressmodel
            ListElement { name:"null" }
        }

        Component
        {
            id:viewdelegate
            Rectangle
            {
                width:listviewcontainer.width
                height:childrenRect.height
                border.color: "lightsteelblue"
                radius:5

                Text {
                    width: parent.width - 10.0
                    text: name
                    font.bold: true
                    anchors.horizontalCenter: parent.horizontalCenter
                    wrapMode: Text.WrapAnywhere
                }

                MouseArea
                {
                    anchors.fill:parent
                    onClicked:
                    {
                        if (inputBox.inputState == "start")
                        {
                            webView.start = name;
                            webView.start = webView.start.split(",")[0];
                            listviewcontainer.y = 440;
                            console.log(webView.start);
                            inputBox.inputState = "null";
                        }
                        if (inputBox.inputState == "end")
                        {
                            webView.end = name;
                            webView.end = webView.end.split(",")[0];
                            listviewcontainer.y = 440;
                            console.log(webView.end);
                            inputBox.inputState = "null";
                        }
                    }
                }
            }
        }

        ListView
        {
            id:addressviewlist
            anchors.fill:parent
            model:addressmodel
            delegate:viewdelegate
        }

        Behavior on y
        {
            NumberAnimation {}
        }

    }
}
