#include "settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent):
    QDialog(parent)
{
    QLabel *typeLabel = new QLabel(tr("Показывать советы"));
    typeBox = new QComboBox;
    typeBox->setEditable(false);
    typeBox->addItem(tr("все"));
    typeBox->addItem(tr("все (с цензурой)"));
    typeBox->addItem(tr("дизайнеру"));
    typeBox->addItem(tr("кодеру"));
    typeBox->addItem(tr("верстальщику"));
    typeBox->addItem(tr("фотографу"));
    typeBox->addItem(tr("копирайтеру"));
    typeBox->addItem(tr("маркетологу"));
    typeBox->addItem(tr("сеошнику"));
    typeBox->addItem(tr("водителю"));
    typeBox->addItem(tr("музыканту"));
    typeBox->addItem(tr("фокуснику"));
    typeBox->addItem(tr("врачу"));
    typeBox->addItem(tr("студенту"));
    typeBox->addItem(tr("за жизнь"));
    typeBox->addItem(tr("для него"));
    typeBox->addItem(tr("для неё"));
    if (settings.value("all").toInt() == RANDOM)
        typeBox->setCurrentIndex(0);
    else
        if (settings.value("all").toInt() == CENSORED)
            typeBox->setCurrentIndex(1);
        else
            typeBox->setCurrentIndex(typeBox->findText(settings.value("type").toString()));
    QHBoxLayout *typeLayout = new QHBoxLayout;
    typeLayout->addWidget(typeLabel);
    typeLayout->addWidget(typeBox);
    autosayBox = new QCheckBox(tr("Автопроизношение"));
    autosayBox->setChecked(settings.value("autosay").toBool());
    saveButton = new QPushButton(tr("Сохранить"));
    QVBoxLayout *layout = new QVBoxLayout();
    layout->addLayout(typeLayout);
    layout->addWidget(autosayBox);
#ifdef Q_WS_MAEMO_5
    layout->addWidget(saveButton);
#else
    cancelButton = new QPushButton(tr("Отмена"));
    QHBoxLayout *buttonLayout = new QHBoxLayout;
    buttonLayout->addWidget(saveButton);
    buttonLayout->addWidget(cancelButton);
    layout->addLayout(buttonLayout);

    connect(cancelButton, SIGNAL(clicked()), this, SLOT(close()));
#endif
    setLayout(layout);

    connect(saveButton, SIGNAL(clicked()), this, SLOT(save()));
}

void SettingsDialog::save()
{
    if (typeBox->currentIndex() == 0)
        settings.setValue("all", RANDOM);
    else
        if (typeBox->currentIndex() == 1)
            settings.setValue("all", CENSORED);
        else
        {
            settings.setValue("all", 0);
            settings.setValue("type", typeBox->currentText());
        }
    settings.setValue("autosay", autosayBox->isChecked());
    settings.sync();
    accept();
}
