#include "mainwindow.h"

#include <QtCore/QCoreApplication>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), id(100)
{
    adviceLabel = new QLabel("Fucking great advice!");
    adviceLabel->setWordWrap(true);
    adviceLabel->setTextFormat(Qt::PlainText);
    adviceLabel->setFont(QFont("Arial", 36));
    adviceLabel->setAlignment(Qt::AlignCenter | Qt::AlignVCenter);
    QScrollArea *scroll = new QScrollArea(this);
    scroll->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    scroll->setWidget(adviceLabel);
    scroll->setWidgetResizable(true);
    okButton = new QPushButton(tr("Ещё!"));
    QVBoxLayout *layout = new QVBoxLayout;
    layout->addWidget(scroll);
    layout->addWidget(okButton);
    QWidget *page = new QWidget;
    page->setLayout(layout);
    setCentralWidget(page);

    lastAction = new QAction(tr("Последний совет"), this);
    copyAction = new QAction(tr("Копировать ссылку"), this);
    sayAction = new QAction(tr("Произнести"), this);
    optionsAction = new QAction(tr("Настройки"), this);
    aboutAction = new QAction(tr("О программе"), this);
    menuBar()->addAction(lastAction);
    menuBar()->addAction(copyAction);
    menuBar()->addAction(sayAction);
    sayAction->setEnabled(false);
    menuBar()->addAction(optionsAction);
    menuBar()->addAction(aboutAction);
    setWindowTitle(tr("Советник"));
    manager = new QNetworkAccessManager(this);

    if (!settings.contains("type"))
    {
        settings.setValue("all", 1);
        settings.setValue("type", "студенту");
        settings.setValue("autosay", false);
    }

    connect(manager, SIGNAL(finished(QNetworkReply*)), this, SLOT(readJson(QNetworkReply*)));
    connect(lastAction, SIGNAL(triggered()), this, SLOT(lastAdvice()));
    connect(okButton, SIGNAL(clicked()), this, SLOT(reloadJson()));
    connect(copyAction, SIGNAL(triggered()), this, SLOT(copyLink()));
    connect(sayAction, SIGNAL(triggered()), this, SLOT(say()));
    connect(optionsAction, SIGNAL(triggered()), this, SLOT(options()));
    connect(aboutAction, SIGNAL(triggered()), this, SLOT(about()));

    audio = Phonon::createPlayer(Phonon::MusicCategory);
}

MainWindow::~MainWindow()
{

}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#if defined(Q_OS_SYMBIAN) || defined(Q_WS_SIMULATOR)
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}

void MainWindow::readJson(QNetworkReply *reply)
{
    if (!reply->error())
    {
        json = reply->readAll();
        renewAdvice();
    }
    else
        QMessageBox::critical(this, tr("Ошибка загрузки данных"),
                  tr("Проверьте соединение с интернетом (код ошибки %1)")
                  .arg(reply->error()));
    reply->deleteLater();
    reply = NULL;
}

void MainWindow::renewAdvice()
{
    if (json.at(0) == '[')
    {
        json.remove(0, 1);
        json.remove(json.length()-1, 1);
    }
    Parser parser(json);
    bool ok = parser.parse();
    QVariantMap* data = parser.toMap();
    if (!ok)
    {
        QMessageBox::critical(this, tr("Ошибка распаковки данных"),
                  tr("Проверьте соединение"));
        return;
    }
    id = data->value("id").toInt();
    QTextDocument adviceHTML;
    adviceHTML.setHtml(data->value("text").toString());
    QString advice = adviceHTML.toPlainText();
    if (advice.length() == 0)
    {
        reloadJson();
        return;
    }
    int a, b;
    while ((a = advice.indexOf(QChar('<'))) != -1)
    {
        if ((b = advice.indexOf(QChar('>'))) != -1)
            advice.remove(a, a-b+1);
        else
            break;

    }
    while ((a = advice.indexOf(QChar('\\'))) != -1)
        advice.remove(a, 2);
    adviceLabel->setText(advice);
    if (data->value("sound").toString().length())
    {
        sound = data->value("sound").toString();
        sayAction->setEnabled(true);
        if (settings.value("autosay").toBool())
            say();
    }
    else
        sayAction->setEnabled(false);
}

void MainWindow::reloadJson()
{
    QString type;
    if (settings.value("all").toInt() == RANDOM)
        type = "random";
    else
        if (settings.value("all").toInt() == CENSORED)
            type = "random/censored/";
        else
            type = QString("random_by_tag/%1").arg(settings.value("type").toString());

    QUrl request(QUrl(QString("http://fucking-great-advice.ru/api/%1").arg(type)));
    manager->get(QNetworkRequest(request));
}

void MainWindow::lastAdvice()
{
    QUrl request(QString("http://fucking-great-advice.ru/api/latest"));
    manager->get(QNetworkRequest(request));
}

void MainWindow::copyLink()
{
    QClipboard *clip = QApplication::clipboard();
    clip->setText(QString("http://fucking-great-advice.ru/advice/%1/").arg(id));
    //clip->setText(QString(json));
}

void MainWindow::say()
{
    audio->setCurrentSource(QString("http://fucking-great-advice.ru/files/sounds/%1").arg(sound));
    audio->play();
}

void MainWindow::options()
{
    SettingsDialog dialog(this);
    dialog.exec();
}

void MainWindow::about()
{
    QMessageBox::about(this, tr("О программе Adviser"),
      tr("Василий Ходаков (binque), 2013"));
}

