# -*- coding: utf-8 -*-
import gobject, gtk, hildon
from hildondesktop import StatusMenuItem
import dbus
from dbus.mainloop.glib import DBusGMainLoop

from advpowlib.util.locale import *
from advpowlib.util.config import *
from advpowcommon.util.execn import *
from advpowcommon.util.format import *
from advpowcommon.sound.system import *
from advpowcommon.ui.Cachers import DITPixbufCacher
from advpowcommon.ui.Animation import DITPBCachedAnimator
from advpowcommon.ui.Banners import HildonBanner
from advpowcommon.ui.Gtk import *
from advpowcommon.ui.Notebook import NotebookMaemo5

class AdvancedPowerMaemo5(StatusMenuItem):

  app_name = 'Advanced Power'
  daemon_name = 'Advanced Power Monitor'
  version = '0.4.2'
  dev_author = 'Kirill Plyashkevich'
  dev_email = 'ru.spirit@gmail.com'
  dev_years = '2008-2010'
  apm_iface = 'ru.spirit.advanced_power_monitor'
  tmp_file = '/tmp/advpow.tmp'
  apm_start_cmd = 'sudo start apmonitord'
  animation_images = ('statusarea_battery_full13', 'statusarea_battery_full25', 'statusarea_battery_full38', 'statusarea_battery_full50', 'statusarea_battery_full63', 'statusarea_battery_full75', 'statusarea_battery_full88', 'statusarea_battery_full100')
  sounds = ['ui-charging_started.wav', 'ui-battery_low.wav', 'ui-recharge_battery.wav']

  def __init__(self):

    def _property_modified_handler(keys):
      for x in keys: self.update_item(x)

    def _name_owner_handler(name, old, new):
      if str(name) == self.apm_iface:
        self.launching_apm = False
        if str(new):
          self.monitor = dbus.Interface(self.bus.get_object(self.apm_iface, '/ru/spirit/advanced_power_monitor'), 'ru.spirit.advanced_power_monitor.request')
          self.__monitor_uid = self.monitor.register()
          self.update_status_menu_apmd_connected()
          self.apm_version_label.set_text('%s %s' % (self.daemon_name, self.monitor.get_version()))
        else:
          self.monitor = None
          self.__monitor_uid = 0
          self.update_status_menu_apmd_disconnected()
          self.apm_version_label.set_text('%s ...' % (self.daemon_name))

    StatusMenuItem.__init__(self)

    self.__info = {'battery_status': 0, 'timeleft_active': 0, 'timeleft_idle': 0}
    self.__lcl = get_locale()
    self.__config = get_config()
    self.__gtk_swr = get_gtk_stock_wrapper()

    self.launching_apm = False
    self.__discharging = True

    self.__status_menu_item = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, self.app_name, 'Waiting for APMD')
    self.__status_menu_item.set_image(gtk.Image())
    self.__status_menu_item.set_image_position(gtk.POS_LEFT)
    self.__status_menu_item.set_alignment(0,0.5, 0, 1)
    self.__status_menu_item.set_title_alignment(0,0.5)
    self.__status_menu_item.set_value_alignment(0,0.5)
    self.__status_menu_item.connect('clicked', self.__status_menu_item_clicked)
    self.add(self.__status_menu_item)

    self.version_label = gtk.Label('%s %s' % (self.app_name, self.version))
    self.apm_version_label = gtk.Label('%s ...' % (self.daemon_name))
    self.copyright_label = gtk.Label(('%s%s %s <%s>') % (u'\u00A9', self.dev_years, self.dev_author, self.dev_email))

    self.__smi_cacher = DITPixbufCacher(48)
    self.__sai_cacher = DITPixbufCacher(22)
    self.__smi_animator = DITPBCachedAnimator(self.animation_images, self.__status_menu_item.get_image().set_from_pixbuf, cacher=self.__smi_cacher)
    self.__sai_animator = DITPBCachedAnimator(self.animation_images, self.set_status_area_icon, cacher=self.__sai_cacher)
    self.set_si('statusarea_battery_insufficient_charging')

    self.__subscribe_keys = ['battery_status', 'timeleft_active', 'timeleft_idle']

    self.__m_loop = DBusGMainLoop()
    self.bus = dbus.SystemBus(mainloop = self.__m_loop, private = True)
    try:
      self.monitor = dbus.Interface(self.bus.get_object(self.apm_iface, '/ru/spirit/advanced_power_monitor'), 'ru.spirit.advanced_power_monitor.request')
      self.__monitor_uid = self.monitor.register()
      self.apm_version_label.set_text('%s %s' % (self.daemon_name, self.monitor.get_version()))
    except Exception, e:
      self.monitor = None
      self.__monitor_uid = 0

    self.signals = {'NameOwnerChanged': {'cb':_name_owner_handler, 'signal_name':'NameOwnerChanged', 'dbus_interface':'org.freedesktop.DBus', 'path':'/org/freedesktop/DBus'}, 'PropertyModified': {'cb':_property_modified_handler, 'signal_name':'PropertyModified', 'dbus_interface':'ru.spirit.advanced_power_monitor.signal', 'path':'/ru/spirit/advanced_power_monitor'}}
    self.init_signals()

    if self.monitor: self.update_status_menu_apmd_connected()
    else: self.update_status_menu_apmd_disconnected()

    self.working = True
    self.connect('destroy', self._cleanup)
    self.show_all()
    #self.__create_settings_box()

  def _cleanup(self, widget=None):
    self.monitor.unregister(self.monitor_uid)
    self.working = False
    for key in self.signals:
      self.bus._clean_up_signal_match(self.signals[key]['receiver_match'])
      self.bus.remove_signal_receiver(self.signals[key]['receiver_match'])
      self.signals[key]['receiver_match'].remove()
    self.destroy()

  def init_signals(self):
    for key in self.signals:
      self.signals[key]['receiver_match'] = self.bus.add_signal_receiver(self.signals[key]['cb'], signal_name=self.signals[key]['signal_name'], dbus_interface=self.signals[key]['dbus_interface'], path=self.signals[key]['path'])

  def __create_settings_box(self):
    settings_dialog = gtk.Dialog('%s Settings' % (self.app_name), None, gtk.DIALOG_NO_SEPARATOR, (gtk.STOCK_SAVE, gtk.RESPONSE_OK))
    about_box = gtk.VBox()
    about_box.pack_start(self.version_label)
    about_box.pack_start(self.apm_version_label)
    about_box.pack_start(self.copyright_label)

    notebook = NotebookMaemo5(settings_dialog.vbox)
    notebook.append_pages([[self.__gtk_swr.get_text(gtk.STOCK_PREFERENCES), gtk.VBox()],[self.__gtk_swr.get_text(gtk.STOCK_ABOUT), about_box]])
    #settings_dialog.vbox.set_size_request(-1, notebook.get_height())
    settings_dialog.show_all()
    notebook.set_active(0)
    response = settings_dialog.run()
    if response == gtk.RESPONSE_OK:
      pass
    settings_dialog.destroy()

  def __status_menu_item_clicked(self, button, user_data=None):
    if self.monitor:
      gobject.idle_add(self.__create_settings_box)
    else:
      if not self.launching_apm:
        self.launching_apm = True
        self.__status_menu_item.set_text(self.app_name, 'Starting APMD')
        run_shell_command(self.apm_start_cmd)

  def update_status_menu_apmd_connected(self):
    self.launching_apm = False
    self.__status_menu_item.set_text(self.app_name, 'APMD connected')
    self.full_subscribe()

  def update_status_menu_apmd_disconnected(self):
    self.launching_apm = False
    self.stop_animation()
    self.set_si('statusarea_battery_insufficient_charging')
    self.__status_menu_item.set_text('Start APMD', 'APMD disconnected')

  def start_animation(self):
    self.__sai_animator.start()
    self.__smi_animator.start()

  def stop_animation(self):
    self.__sai_animator.stop()
    self.__smi_animator.stop()

  def set_si(self, key):
    self.set_smi(key)
    self.set_sai(key)

  def set_smi(self, key):
    self.__status_menu_item.get_image().set_from_pixbuf(self.__smi_cacher.get(key))

  def set_sai(self, key):
    self.set_status_area_icon(self.__sai_cacher.get(key))

  def update_item(self, key):
    if key in self.__subscribe_keys:
      self.__info[key] = self.monitor.get_value(key)
      getattr(self, 'handle_%s' % key)(key)

  def full_subscribe(self):
    self.monitor.subscribe(self.__monitor_uid, self.__subscribe_keys)
    for key in self.__subscribe_keys: self.update_item(key)

  def handle_battery_status(self, key):
    battery_state = '%s: %s' % (self.__lcl.get_item('timeleft'), self.__lcl.get('unknown'))
    battery_value = '%s: %s' % (self.__lcl.get_item('battery_status'), u'\u221E')
    self.__discharging = False
    state = self.monitor.get_battery_state()
    if state == 'charging':
      battery_state = self.__lcl.get_item('%s_%s' % (key, state))
      HildonBanner.show_information(self.__status_menu_item, battery_state)
      play_system_sound(self.sounds[0])
      self.start_animation()
    else:
      self.stop_animation()
      if state == 'full':
        battery_state = self.__lcl.get_item('%s_%s' % (key, state))
        self.update_battery_view('99.9%')
        HildonBanner.show_information(self.__status_menu_item, battery_state)
      elif state == 'charger_disconn':
        battery_state = self.__lcl.get_item('%s_%s' % (key, state))
        HildonBanner.show_information(self.__status_menu_item, battery_state)
      else:
        self.__discharging = True
        battery_value = self.update_battery_view(state)
    self.__status_menu_item.set_text(battery_value, battery_state)
    self.update_timeleft()

  def update_battery_view(self, state):
    battery_state = '%s: %s' % (self.__lcl.get_item('battery_status'), state)
    state = float(state.split('%')[0])
    image = 'statusarea_battery_insufficient_charging'
    if state > 88:
      image = 'statusarea_battery_full100'
    elif state > 75:
      image = 'statusarea_battery_full88'
    elif state > 63:
      image = 'statusarea_battery_full75'
    elif state > 50:
      image = 'statusarea_battery_full63'
    elif state > 38:
      image = 'statusarea_battery_full50'
    elif state > 25:
      image = 'statusarea_battery_full38'
    elif state > 13:
      image = 'statusarea_battery_full25'
    elif state > 5:
      image = 'statusarea_battery_full13'
    elif state > 2:
      image = 'statusarea_battery_low'
      play_system_sound(self.sounds[1])
    else:
      image = 'statusarea_battery_verylow'
      play_system_sound(self.sounds[2])
    self.set_si(image)
    return battery_state

  def handle_timeleft_active(self, key):
    self.update_timeleft()

  def handle_timeleft_idle(self, key):
    self.update_timeleft()

  def update_timeleft(self):
    if self.__discharging:
      if self.__info['timeleft_idle'] > 60:
        self.__status_menu_item.set_value('%s | %s:00' % (get_formatted_time(self.__info['timeleft_active'], format=1), get_formatted_time(self.__info['timeleft_idle'], format=2)))
      else:
        self.__status_menu_item.set_value('%s | %s' % ( get_formatted_time(self.__info['timeleft_active'], format=1), get_formatted_time(self.__info['timeleft_idle'], format=2)))

def get_hd_plugin_type(): return AdvancedPowerMaemo5
