'''
Abstract Daemon
2009(c) Kiril Plyashkevich <ru.spirit@gmail.com>
Class for creating daemons.
'''
import sys, os, time, atexit
from signal import SIGTERM

class AbstractDaemon():
  def __init__(self, pidfile='/tmp/abstract_daemon.pid', stdin='/dev/null', stdout='/dev/null', stderr='/dev/null'):
    self.stdin = stdin
    self.stdout = stdout
    self.stderr = stderr
    self.pidfile = pidfile

  def __daemonize(self):
    try: 
      pid = os.fork() 
      if pid > 0:
        sys.exit(0) 
    except OSError, e:
      print e
      sys.stderr.write("Fork #1 failed: %d (%s)\n" % (e.errno, e.strerror))
      sys.exit(1)

    os.chdir("/") 
    os.setsid() 
    os.umask(0) 

    try: 
      pid = os.fork() 
      if pid > 0:
        sys.exit(0) 
    except OSError, e: 
      print e
      sys.stderr.write("Fork #2 failed: %d (%s)\n" % (e.errno, e.strerror))
      sys.exit(1) 

    sys.stdout.flush()
    sys.stderr.flush()
    si = file(self.stdin, 'r')
    so = file(self.stdout, 'a+')
    se = file(self.stderr, 'a+', 0)
#    os.dup2(si.fileno(), sys.stdin.fileno())
#    os.dup2(so.fileno(), sys.stdout.fileno())
#    os.dup2(se.fileno(), sys.stderr.fileno())

    atexit.register(self.__delpid)
    pid = str(os.getpid())
    pidf = file(self.pidfile,'w+')
    pidf.write("%s\n" % pid)
    pidf.close()

  def __delpid(self):
    os.remove(self.pidfile)

  def start(self):
    pid = self.__get_pid()
    if pid:
      message = "File %s already exist. Daemon already running?\n"
      sys.stderr.write(message % self.pidfile)
      sys.exit(1)
    self.__daemonize()
    self.run()

  def stop(self):
    pid = self.__get_pid()

    if not pid:
      message = "File %s does not exist. Daemon not running?\n"
      sys.stderr.write(message % self.pidfile)
      return

    try:
      while 1:
        os.kill(pid, SIGTERM)
        time.sleep(0.5)
    except OSError, err:
      err = str(err)
      if err.find("No such process") > 0:
        if os.path.exists(self.pidfile):
          os.remove(self.pidfile)
      else:
        print str(err)
        sys.exit(1)

  def restart(self):
    self.stop()
    self.start()

  def __get_pid(self):
    pid = None
    try:
      pf = file(self.pidfile,'r')
      pid = int(pf.read().strip())
      pf.close()
    except IOError:
      pass
    return pid

  def run(self):
    pass

  def process_args(self):
    if len(sys.argv) == 2:
      if 'start' == sys.argv[1]:
        print 'Starting...'
        self.start()
      elif 'stop' == sys.argv[1]:
        print 'Stopping...'
        self.stop()
      elif 'restart' == sys.argv[1]:
        print 'Restarting...'
        self.restart()
      else:
        print "Unknown command: %s" % sys.argv[1]
        print "Usage: %s start|stop|restart" % sys.argv[0]
        sys.exit(2)
      sys.exit(0)
    else:
      print "Usage: %s start|stop|restart" % sys.argv[0]
      sys.exit(2)
