# -*- coding: utf-8 -*-

'''
Advanced Interface Switcher
2010-2011(c) Kirill Plyashkevich <ru.spirit@gmail.com>
WLAN interface object
'''

import dbus, gobject
from advifswlib.interfaces.Abstract import AbstractInterface
from advpowcommon.util.execn import *

class WLANInterface(AbstractInterface):

  wifi_module_path = '/org/freedesktop/Hal/Manager'
  wifi_module_iface = 'org.freedesktop.Hal.Manager'
  wifi_module_signal = None
  wifi_turn_on_cmd = ['sudo /usr/bin/advifsw_wlan_on.sh']
  wifi_turn_off_cmd = ['sudo /usr/bin/advifsw_wlan_off.sh']
  wifi_icd2_path = '/com/nokia/icd2'
  wifi_icd2_iface = 'com.nokia.icd2'
  wifi_icd2_state_signal = 'state_sig'
  wifi_icd2_statistics_signal = 'statistics_sig'
  wifi_icdui_path = '/com/nokia/icd_ui'
  wifi_icdui_iface = 'com.nokia.icd_ui'

  def pre_init(self):
    self.has_be = get_shell_command_output('ls /lib/modules/$(uname -r) | grep -m 1 wl1251') != ''
    self.state = {
    'name': 'WLAN',
    'dbus': {
      'on': {'name': self.wifi_module_signal, 'iface': self.wifi_module_iface, 'path': self.wifi_module_path, 'args': {'member_keyword': 'member'}},
      'connected': {'name': self.wifi_icd2_state_signal, 'iface': self.wifi_icd2_iface, 'path': self.wifi_icd2_path, 'args': {}},
      'statistics': {'name': self.wifi_icd2_statistics_signal, 'iface': self.wifi_icd2_iface, 'path': self.wifi_icd2_path, 'args': {}}
    },
    'images': ('ifsw_statusarea_wlan_off', 'ifsw_statusarea_wlan_signal_0', 'ifsw_statusarea_wlan_signal_3'),
    'images_st': ('ifsw_statusarea_wlan_signal_0', 'ifsw_statusarea_wlan_signal_1', 'ifsw_statusarea_wlan_signal_1', 'ifsw_statusarea_wlan_signal_2', 'ifsw_statusarea_wlan_signal_3', 'ifsw_statusarea_wlan_signal_3'),
    'text': ('Off', 'On', '<>'),
    'show': (True, False, False),
    'banner': (True, True, True),
    'value': 0,
    'strength': 0,
    'modes': ('wlan-stock',),
    'mode': 0
    }
    if self.has_be:
      self.state['modes'] = ('wlan-stock', 'wlan-bleeding-edge')
    self.interfaces = {
      'ICD': [self.wifi_icd2_iface, self.wifi_icd2_path, self.wifi_icd2_iface, '/usr/sbin/icd2', False],
      'ICD_UI': [self.wifi_icdui_iface, self.wifi_icdui_path, self.wifi_icdui_iface, '/usr/sbin/icd2', False]
    }

  def process_signal_on(self, *args, **kwargs):
    if args[0] == '/org/freedesktop/Hal/devices/platform_wl12xx':
      state = int(kwargs['member'] == 'DeviceAdded')
      if state and self.get_config_value('show-connection-dialog'):
        #self.scan_request()
        gobject.idle_add(self.show_connection_dialog)
      return state, 0, None
    else: return None, None, None

  def process_signal_connected(self, *args):
    if len(args) == 8 and args[3].startswith('WLAN_'):
      if args[7] == 2:
        gobject.timeout_add(1000, self.get_strength)
        return 2, 0, None
      elif args[7] == 0 and self.state['value'] != 0:
        return 1, 0, None
      else:
        return self.state['value'], 0, None
    else:
      return None, None, None

  def process_signal_statistics(self, *args):
    return None, None, min(int(args[7]), 5)

  def get_status(self):
    result = int(get_shell_command_output('lsmod | grep -m 1 wl12xx') != '')
    if result:
      try: self.get_interface('ICD').state_req()
      except: self.reinit_interface('ICD')
    return result, 0, 0

  def turn_on(self):
    if self.state['value'] == 0:
      #run_async(self.run_commands, (self.wifi_turn_on_cmd,))
      gobject.idle_add(self.run_commands, self.wifi_turn_on_cmd)
    elif self.state['value'] == 2:
      try: self.get_interface('ICD').disconnect_req(dbus.UInt32(0x8000))
      except: self.reinit_interface('ICD')

  def turn_off(self):
    if self.state['value'] > 0:
      if self.state['value'] == 2:
        try: self.get_interface('ICD').disconnect_req(dbus.UInt32(0x8000))
        except: self.reinit_interface('ICD')
      #run_async(self.run_commands, (self.wifi_turn_off_cmd,))
      gobject.idle_add(self.run_commands, self.wifi_turn_off_cmd)

  def run_commands(self, cmds):
    run_shell_command(' && '.join(cmds))
#    self.scan_request()
    self.switched()

  def show_connection_dialog(self):
    self.get_interface('ICD_UI').show_conn_dlg(False)

  def scan_request(self):
    try: self.get_interface('ICD').scan_req(dbus.UInt32(0), dbus.Array([], signature='s'))
    except: self.reinit_interface('ICD')

  def get_strength(self):
    if self.state['value'] == 2:
      self.get_interface('ICD').statistics_req()
      gobject.timeout_add(5000, self.get_strength)
    return False

  def turn_mode(self, mode):
    self.switched()
