# -*- coding: utf-8 -*-
import gobject, gtk, hildon
from hildondesktop import StatusMenuItem
import dbus
from dbus.mainloop.glib import DBusGMainLoop
from advpowcommon.ui.Cachers import DITPixbufCacher
from advpowcommon.ui.Animation import DITPBCachedAnimator
from advpowcommon.ui.Config import ConfigUIMaemo5
from advpowcommon.ui.Gtk import *
from advpowcommon.ui.Notebook import NotebookMaemo5
from advifswlib.interfaces.GSM import GSMInterface
from advifswlib.interfaces.BT import BTInterface
from advifswlib.interfaces.FlightMode import FlightMode
from advifswlib.interfaces.WLAN import WLANInterface
from advifswlib.util.config import *
from advifswlib.util.locale import *

class AdvancedInterfaceSwitcherMaemo5(StatusMenuItem):

  app_name= 'Advanced Interface Switcher'
  version = '0.3.7'
  dev_author = 'Kirill Plyashkevich'
  dev_email = 'ru.spirit@gmail.com'
  dev_years = '2010-2011'

  def __init__(self):

    StatusMenuItem.__init__(self)
    self.__lcl = get_locale()
    self.__interfaces = []
    self.__animation_images = {}
    self.__gtk_swr = get_gtk_stock_wrapper()
    self.__config = get_config()
    self.__config_ui = ConfigUIMaemo5()
    self.__sai_cacher = DITPixbufCacher(18)
    self.__sai_animator = DITPBCachedAnimator([], self.set_status_area_icon, cacher=self.__sai_cacher, time_out=1000)
    self.__m_loop = DBusGMainLoop()
    self.__bus = dbus.SystemBus(mainloop = self.__m_loop, private = True)

    ifaces = (GSMInterface, BTInterface, WLANInterface)#, FlightMode)
    self.__smi_box = gtk.Table(len(ifaces), 1, True)
    self.add(self.__smi_box)
    ilist = enumerate(ifaces)

    #loaded_list = ''
    #loaded_ifaces = 0
    for iface in ilist:
      try:
        self.__interfaces.append(iface[1](self.__bus, self.process_sai, self.__show_settings_dialog))
        self.__smi_box.attach(self.__interfaces[iface[0]].get_button(), iface[0], iface[0]+1, 0, 1, gtk.EXPAND | gtk.FILL, gtk.SHRINK)
        #loaded_ifaces += 1
        #loaded_list = '%s\n%s' % (loaded_list, self.__interfaces[iface[0]].get_name())
      except Exception, e:
        #loaded_list = '%s\nError: %s' % (loaded_list, e)
        print e
        pass
    #result = 'Loaded (%s/%s):%s\n' % (loaded_ifaces, len(ifaces), loaded_list)
    #print result
    self.show_all()

  def __show_settings_dialog(self, button=None):
    self.__config.load()
    settings_dialog = gtk.Dialog('%s' % (self.app_name), None, gtk.DIALOG_MODAL | gtk.DIALOG_NO_SEPARATOR, self.__config_ui.get_dialog_buttons())
    wpa = gtk.VBox()
    config_controls = {}
    config_keys = self.__config.get_keys()
    config_keys.sort()
    for config_key in config_keys:
      name, ck_type, value = self.__config.get_entry(config_key)
      config_options = self.__config.get_option(config_key)
      options = ()
      if config_options:
        options = zip(map(self.__lcl.get, config_options), config_options)
      config_control = self.__config_ui.create_control(self.__lcl.get_settings(config_key), ck_type, (self.__lcl.get_settings(str(value)), value), options)
      if config_control:
        config_controls[config_key] = config_control
        wpa.pack_start(config_control, False)

    about_page = gtk.VBox()
    about_page.pack_start(gtk.Label('%s %s' % (self.app_name, self.version)))
    about_page.pack_start(gtk.Label('%s%s %s <%s>' % (u'\u00A9', self.dev_years, self.dev_author, self.dev_email)))

    settings_dialog.show_all()
    notebook = NotebookMaemo5()
    notebook.set_box(settings_dialog.vbox)
    notebook.append_items(([[self.__gtk_swr.get_text(gtk.STOCK_PREFERENCES), wpa], [self.__gtk_swr.get_text(gtk.STOCK_ABOUT), about_page]]))
    settings_dialog.vbox.set_size_request(-1, min(350, notebook.get_height()))
    response = settings_dialog.run()

    if response == gtk.RESPONSE_OK:
      controls_keys = config_controls.keys()
      for config_key in config_keys:
        if config_key in controls_keys:
          name, ck_type, value = config.get_entry(config_key)
          value = self.__config_ui.get_value(config_controls[config_key], value, ck_type)
          self.__config.set_value(config_key, value)
      self.__config.save()
    settings_dialog.destroy()

  def process_sai(self, iname, image='', add=True):
    if add:
      try:
        self.__sai_animator.remove_image(self.__animation_images[iname])
      except:
        pass
      self.__animation_images[iname] = image
      self.__sai_animator.add_image(image)
    else:
      try:
        image = self.__animation_images[iname]
        self.__sai_animator.remove_image(image)
      except:
        pass

  def __set_sai(self, key):
    self.set_status_area_icon(self.__sai_cacher.get(key))

def get_hd_plugin_type(): return AdvancedInterfaceSwitcherMaemo5
