# -*- coding: utf-8 -*-
import gobject
from advifswlib.interfaces.Abstract import AbstractInterface

class FlightMode(AbstractInterface):

  flight_mode_module_iface = 'com.nokia.mce.signal'
  flight_mode_module_signal = 'sig_device_mode_ind'
  flight_mode_module_path = '/com/nokia/mce/signal'
  flight_mode_module_iface_iface = 'com.nokia.mce'
  flight_mode_module_iface_name = 'com.nokia.mce.request'
  flight_mode_module_iface_path = '/com/nokia/mce/request'

  def pre_init(self):
    self.state = {
    'name': 'FlightMode',
    'dbus': {
      'on': {'name': self.flight_mode_module_signal, 'iface': self.flight_mode_module_iface, 'path': self.flight_mode_module_path, 'args': {}}
    },
    'images': ('ifsw_statusarea_flight_mode_on2', 'ifsw_statusarea_flight_mode_off2'),
    'text': ('Off', 'On'),
    'show': (False, True),
    'banner': (False, False),
    'value': 0
    }
    self.interfaces = {'MCE': [self.flight_mode_module_iface_iface, self.flight_mode_module_iface_path, self.flight_mode_module_iface_name, '']}

  def process_signal_on(self, value):
    try:
      result = ['normal', 'flight'].index(str(value))
    except:
      result = 0
    return result

  def get_status(self):
    try:
      result = ['normal', 'flight'].index(str(self.get_interface('MCE').get_device_mode()))
    except:
      result = 0
    return result

  def turn_on(self):
    gobject.idle_add(self.run_commands, True)

  def turn_off(self):
    gobject.idle_add(self.run_commands, False)

  def run_commands(self, flag):
    if (flag):
      self.get_interface('MCE').req_device_mode_change('flight')
    else:
      self.get_interface('MCE').req_device_mode_change('normal')
    self.switched()
