# -*- coding: utf-8 -*-
import gobject
from advifswlib.interfaces.Abstract import AbstractInterface

class GSMInterface(AbstractInterface):

  cellular_system_iface = 'Phone.Net'
  cellular_system_signal = 'cellular_system_state_change'
  cellular_system_path = '/com/nokia/phone/net'
  cellular_system_iiface = 'com.nokia.phone.net'

  gsm_module_iface = 'com.nokia.phone.SSC'
  gsm_module_signal = 'modem_state_changed_ind'
  gsm_module_path = '/com/nokia/phone/SSC'

  def pre_init(self):
    self.state = {
    'name': 'GSM',
    'dbus': {
      'on': {'name': self.cellular_system_signal, 'iface': self.cellular_system_iface, 'path': self.cellular_system_path, 'args': {}},
      'connected': {'name': self.gsm_module_signal, 'iface': self.gsm_module_iface, 'path': self.gsm_module_path, 'args': {}}
    },
    'images': ('ifsw_statusarea_cell_off', 'ifsw_statusarea_cell_on', 'ifsw_statusarea_cell_online'),
    'text': ('Off', 'On', '<>'),
    'show': (True, True, False),
    'banner': (True, False, True),
    'value': 0
    }
    self.interfaces = {'Phone': [self.cellular_system_iiface, self.cellular_system_path, self.cellular_system_iface, ''], 'SSC': [self.gsm_module_iface, self.gsm_module_path, self.gsm_module_iface, '']}

  def process_signal_on(self, state, arg1, arg2):
    return int(state)

  def process_signal_connected(self, value):
    try:
      result = 1 + ['activation_pending', 'online'].index(str(value))
    except:
      result = None
    return result

  def get_status(self):
    try:
      status = int(self.get_interface('Phone').get_registration_status()[0])
      result = 0
      if status in (3,4,5,9,10,11):
        result = 1
      elif status in (0,1,2):
        result = 2
      #result = ['offline', 'activation_pending', 'online'].index(str(self.get_interface('SSC').get_modem_state()))
    except Exception, e:
      print e
      result = 0
    return result

  def turn_on(self):
    gobject.idle_add(self.run_commands, True)

  def turn_off(self):
    gobject.idle_add(self.run_commands, False)

  def run_commands(self, flag):
    self.get_interface('SSC').set_radio(flag)
    self.switched()
