# -*- coding: utf-8 -*-
import gobject
from advifswlib.interfaces.Abstract import AbstractInterface
from advpowcommon.util.execn import *

class BTInterface(AbstractInterface):

  bt_adapter_iface = 'org.bluez.Adapter'
  bt_device_iface = 'org.bluez.Device'
  bt_adapter_signal = 'PropertyChanged'
  bt_device_signal = 'PropertyChanged'
  bt_adapter_path = get_shell_command_output('dbus-send --system --dest=org.bluez --print-reply / org.bluez.Manager.DefaultAdapter | tail -1 | sed \'s/^.*"\\(.*\\)".*$/\\1/\' 2>/dev/null').replace('\n', '')
  bt_device_path = None

  def pre_init(self):
    self.state = {
    'name': 'Bluetooth',
    'dbus': {
      'on': {'name': self.bt_adapter_signal, 'iface': self.bt_adapter_iface, 'path': self.bt_adapter_path, 'args': {}},
      'connected': {'name': self.bt_device_signal, 'iface': self.bt_device_iface, 'path': self.bt_device_path, 'args': {'path_keyword': 'path'}}
    },
    'images': ('ifsw_statusarea_bluetooth_off', 'ifsw_statusarea_bluetooth_on', 'ifsw_statusarea_bluetooth_online'),
    'text': ('Off', 'On', '<>'),
    'show': (False, True, True),
    'banner': (True, False, True),
    'value': 0
    }
    self.interfaces = {'BlueZAdapter': ['org.bluez', self.bt_adapter_path, self.bt_adapter_iface, '']}
    self.connected_device = set()

  def process_signal_connected(self, prop, value, **kwargs):
    if str(prop) == 'Connected':
      device = kwargs['path'].replace('%s/' % self.bt_adapter_path, '')
      if value:
        self.connected_device.add(device)
        return 2
      else:
        self.connected_device.remove(device)
        if len(self.connected_device) == 0:
          return 1
        else:
          return None
    else:
      return None

  def process_signal_on(self, prop, value, **kwargs):
    if str(prop) == 'Powered':
      return int(value)
    else:
      return None

  def get_status(self):
    powered = int(self.get_interface('BlueZAdapter').GetProperties()['Powered'])
    return powered

  def turn_on(self):
    gobject.idle_add(self.run_commands, True)

  def turn_off(self):
    for device in self.connected_device:
      conndev_iface = dbus.Interface(self.get_bus().get_object('org.bluez', '%s/%s' % (self.bt_adapter_path, device)), self.bt_device_iface)
      conndev_iface.Disconnect()
    gobject.idle_add(self.run_commands, False)

  def run_commands(self, flag):
    self.get_interface('BlueZAdapter').SetProperty('Powered', flag)
    self.switched()
