# -*- coding: utf-8 -*-
import dbus, gobject
from ifaceswlib.interfaces.Abstract import AbstractInterface
from advpowcommon.util.execn import *

class WLANInterface(AbstractInterface):

  wifi_module_path = '/org/freedesktop/Hal/Manager'
  wifi_module_iface = 'org.freedesktop.Hal.Manager'
  wifi_module_signal = None
  wifi_turn_on_cmd = ['sudo /usr/bin/advifsw_wlan_on.sh']
  wifi_turn_off_cmd = ['sudo /usr/bin/advifsw_wlan_off.sh']
  wifi_icd2_path = '/com/nokia/icd2'
  wifi_icd2_iface = 'com.nokia.icd2'
  wifi_icd2_signal = 'state_sig'

  def pre_init(self):
    self.state = {
    'name': 'WLAN',
    'dbus': {
      'on': {'name': self.wifi_module_signal, 'iface': self.wifi_module_iface, 'path': self.wifi_module_path, 'args': {'member_keyword': 'member'}},
      'connected': {'name': self.wifi_icd2_signal, 'iface': self.wifi_icd2_iface, 'path': self.wifi_icd2_path, 'args': {}}
    },
    'images': ('ifsw_statusarea_wlan_off', 'ifsw_statusarea_wlan_on', 'ifsw_statusarea_wlan_online'),
    'text': ('Off', 'On', '<>'),
    'show': (True, False, False),
    'banner': (True, True, True),
    'value': 0
    }
    self.interfaces = {'ICD': ['com.nokia.icd2', '/com/nokia/icd2', 'com.nokia.icd2', '/usr/sbin/icd2']}

  def process_signal_on(self, *args, **kwargs):
    if args[0] == '/org/freedesktop/Hal/devices/platform_wl12xx':
      return int(kwargs['member'] == 'DeviceAdded')
    else:
      return None

  def process_signal_connected(self, *args):
    if len(args) == 8 and args[3].startswith('WLAN_'):
      if args[7] == 2:
        return 2
      elif args[7] == 0 and self.state['value'] != 0:
        return 1
      else:
        return self.state['value']
    return None

  def get_status(self):
    result = int(get_shell_command_output('lsmod | grep -o wl12xx') != '')
    if result:
      try:
        self.get_interface('ICD').state_req()
      except:
        self.reinit_interface('ICD')
        self.get_interface('ICD').state_req()
    return result

  def turn_on(self):
    #run_async(self.run_commands, (self.wifi_turn_on_cmd,))
    gobject.idle_add(self.run_commands, self.wifi_turn_on_cmd)

  def turn_off(self):
    if self.state['value'] == 2:
      try:
        self.get_interface('ICD').disconnect_req(dbus.UInt32(32768))
      except:
        self.reinit_interface('ICD')
        self.get_interface('ICD').disconnect_req(dbus.UInt32(32768))
    #run_async(self.run_commands, (self.wifi_turn_off_cmd,))
    gobject.idle_add(self.run_commands, self.wifi_turn_off_cmd)

  def run_commands(self, cmds):
    run_shell_command(' && '.join(cmds))
#    self.scan_request()
    self.switched()

  def scan_request(self):
    try:
      self.get_interface('ICD').scan_req(dbus.UInt32(0), dbus.Array([], signature='s'))
    except:
      pass
      #self.reinit_interface('ICD')
      #self.get_interface('ICD').scan_req(dbus.UInt32(0), dbus.Array([], signature='s'))
