# -*- coding: utf-8 -*-

'''
Advanced Interface Switcher
2010-2012(c) Kirill Plyashkevich <ru.spirit@gmail.com>
GSM interface object
'''

import dbus, gobject
from advpowcommon.util.execn import *
from advifswlib.interfaces.Abstract import InterfaceState, AbstractInterface

class GSMInterface(AbstractInterface):

  phone_iface = 'com.nokia.phone.net'
  phone_path = '/com/nokia/phone/net'
  phone_iiface = 'Phone.Net'

  cellular_system_signal = 'cellular_system_state_change'
  radio_access_signal = 'radio_access_technology_change'
  strength_signal = 'signal_strength_change'
  operator_signal = 'operator_name_change'

  status_on = (3,4,5,9,10,11)
  status_connected = (0,1,2)

  gsm_module_iface = 'com.nokia.phone.SSC'
  gsm_module_path = '/com/nokia/phone/SSC'
  gsm_module_signal = 'modem_state_changed_ind'
  sim_iface = 'com.nokia.phone.SIM'
  sim_path = '/com/nokia/phone/SIM'
  sim_iiface = 'Phone.Sim'

  def pre_init(self):
    self.state = {'name': 'GSM',
                  'dbus': {'on': {'name': self.cellular_system_signal, 
                                  'iface': self.phone_iiface, 
                                  'path': self.phone_path, 
                                  'args': {}},
                           'connected': {'name': self.gsm_module_signal, 
                                         'iface': self.gsm_module_iface, 
                                         'path': self.gsm_module_path, 
                                         'args': {}},
                           'strength': {'name': self.strength_signal, 
                                        'iface': self.phone_iiface, 
                                        'path': self.phone_path, 
                                        'args': {}},
                           'operator': {'name': self.operator_signal, 
                                        'iface': self.phone_iiface, 
                                        'path': self.phone_path, 
                                        'args': {}},
                          },
                  'images': ('ifsw_statusarea_cell_off', 
                             'ifsw_statusarea_cell_signal_0', 
                             'ifsw_statusarea_cell_signal_5',
                             'ifsw_statusarea_cell_connecting'),
                  'images_st': ('ifsw_statusarea_cell_signal_0', 
                                'ifsw_statusarea_cell_signal_1', 
                                'ifsw_statusarea_cell_signal_2', 
                                'ifsw_statusarea_cell_signal_3', 
                                'ifsw_statusarea_cell_signal_4', 
                                'ifsw_statusarea_cell_signal_5'),
                  'text': ['Off', 'On', '<>', 'Connecting'],
                  'show': (True, True, False, True),
                  'banner': (True, True, True, True),
                  'value': InterfaceState.off,
                  'strength': 0,
                  'modes': ('gsm-3g+gsm', 'gsm-2g', 'gsm-3g'),
                  'mode': 0}
    self.interfaces = {'Phone': [self.phone_iface, self.phone_path, 
                                 self.phone_iiface, '', False], 
                       'SSC': [self.gsm_module_iface, self.gsm_module_path, 
                               self.gsm_module_iface, '', True],
                       'SIM': [self.sim_iface, self.sim_path, 
                               self.sim_iiface, '', False]}

  def process_signal_on(self, state, arg1, arg2):
    return self.get_status()

  def process_signal_connected(self, value):
    try:
      value = str(value)
      result = None
      strength = None
      if value == 'inactive':
        result = InterfaceState.off
      elif value == 'activation_pending':
        #result = InterfaceState.on
        result = InterfaceState.connecting
      elif value == 'online':
        result = InterfaceState.connected
        if self.get_config_value('show-signal-strength'):
          strength = self.get_strength()
        sp_info = self.get_interface('SIM').get_service_provider_name()
        self.process_signal_operator(None, sp_info[0])
      else: #'activation_failed', 'selection_failed'
        result = InterfaceState.on
      #return 1 + ['activation_pending', 'online'].index(str(value)), 
      return result, self.get_mode(), strength
    except:
      return None, None, None

  def process_signal_strength(self, arg1, arg2):
    if self.get_config_value('show-signal-strength'):
      return None, None, self.get_strength_value(arg1)
    else:
      return None, None, None

  def process_signal_operator(self, arg1, opname, empty=None, mnc=None, mcc=None):
    opname = str(opname)
    #if not opname:
    #  self.state['text'][InterfaceState.connected] = '<>'
    #else:
    if opname:
      self.state['text'][InterfaceState.connected] = opname
    return None, None, None

  def get_status(self):
    value = self.get_interface('SSC').get_modem_state()
    return self.process_signal_connected(value)

  def turn_on(self):
    gobject.idle_add(self.run_commands, True)

  def turn_off(self):
    gobject.idle_add(self.run_commands, False)

  def turn_mode(self, mode):
    gobject.idle_add(self.run_mode_commands, mode)

  def run_commands(self, flag):
    self.get_interface('SSC').set_radio(flag)
    self.switched()

  def run_mode_commands(self, mode):
    self.get_interface('Phone').set_selected_radio_access_technology(dbus.Byte(mode))
    self.switched()

  def get_mode(self):
    return int(self.get_interface('Phone').get_selected_radio_access_technology()[0])

  def get_strength(self):
    arg1, arg2, arg3 = self.get_interface('Phone').get_signal_strength()
    return self.get_strength_value(arg1)

  def get_strength_value(self, value):
    return (value+20)/21 #int(round(min(1.0, float(value)/100.0)*5))
