# -*- coding: utf-8 -*-

'''
Advanced Interface Switcher
2010-2012(c) Kirill Plyashkevich <ru.spirit@gmail.com>
System menu plugin class
'''

#from __future__ import with_statement
#import threading
import gobject
import gtk
import re
import hildon
from hildondesktop import StatusMenuItem
import dbus
from dbus.mainloop.glib import DBusGMainLoop

from advpowcommon.ui.Cachers import DITPixbufCacher
from advpowcommon.ui.Animation import DITPBCachedAnimator
from advpowcommon.ui.Config import ConfigUIMaemo5
from advpowcommon.ui.Gtk import *
from advpowcommon.ui.Notebook import NotebookMaemo5
from advifswlib.interfaces.GSM import GSMInterface
from advifswlib.interfaces.BT import BTInterface
from advifswlib.interfaces.WLAN import WLANInterface
import advifswlib.util.cacher as cacher
import advifswlib.util.worker as worker
import advifswlib.util.config as config
import advifswlib.util.locale as locale

class AdvancedInterfaceSwitcherMaemo5(StatusMenuItem):

  app_name = 'Advanced Interface Switcher'
  version = '0.3.11'
  dev_author = 'Kirill Plyashkevich'
  dev_email = 'ru.spirit@gmail.com'
  dev_years = '2010-2012'

  def __init__(self):

    StatusMenuItem.__init__(self)
    #self.__ui_lock = threading.Lock()
    self.__lcl = locale.get()
    self.__interfaces = {}
    self.__iface_config_re = re.compile(r'settings/(\w+)/.+')
    self.__animation_images = {}
    self.__gtk_swr = get_gtk_stock_wrapper()
    self.__config = config.get()
    self.__config_ui = ConfigUIMaemo5()
    self.__sai_cacher = DITPixbufCacher(18)
    self.__sai_animator = DITPBCachedAnimator([], self.set_status_area_icon, 
                                              cacher=self.__sai_cacher, 
                                              time_out=2000)
    #ocasionally found out that my dbus initialization is a good workaround
    #for bug #8611
    self.__m_loop = DBusGMainLoop()
    self.__bus = dbus.SystemBus(mainloop = self.__m_loop, private = True)
    self.__available_ifaces = (GSMInterface, BTInterface, WLANInterface)#, FlightMode)
    self.__smi_box = gtk.HBox(True)#gtk.Table(len(self.__available_ifaces), 1, True)
    smi_vbox = gtk.VBox(False)
    smi_vbox.pack_start(self.__smi_box)
    #self.add(self.__smi_box)
    self.add(smi_vbox)

    loaded_list = ''
    active = 0
    for iface in self.__available_ifaces:
      key = iface.name.lower()
      if self.__config.get_value('settings/%s/enabled' % (key)):
        try:
          obj = self.__init_iface(iface)
          self.__interfaces[key] = obj
          loaded_list = '%s\n%s (%s)' % (loaded_list, obj.get_name(),
                                         obj.__class__)
          active += 1
        except Exception, e:
          loaded_list = '%s\n%s\nError: %s\n' % (loaded_list, iface, e)
          pass
      else:
        self.__interfaces[key] = None
    self.__setup_buttons()

    self.__settings_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
      hildon.BUTTON_ARRANGEMENT_VERTICAL,
      self.__gtk_swr.get_text(gtk.STOCK_PREFERENCES),
      self.app_name)
    self.__settings_button.set_image(gtk.Image())
    self.__settings_button.get_image().set_from_pixbuf(cacher.get().get('general_settings'))
    self.__settings_button.set_alignment(0.5,0.5,1,1)
    self.__settings_button.set_title_alignment(0.0,0.5)
    self.__settings_button.connect('clicked', self.__settings_button_clicked)

    smi_vbox.pack_start(self.__settings_button)
      #self.__smi_box.attach(self.__settings_button,
      #  ind, len(self.__available_ifaces) - 1, 0, 1,
      #  gtk.EXPAND | gtk.FILL,
      #  gtk.SHRINK)
    self.__settings_dialog = None
    self.__config_controls = {}
    print '\n%s\n%s' % (self.app_name, self.version)
    print '\nLoaded (%s/%s)%s\n' % (active, len(self.__available_ifaces), loaded_list)
    self.show_all()
    if active:
      self.__settings_button.hide()
    #self.__show_settings_dialog()

  def destroy(self):
    for iface in self.__interfaces:
      if self.__interfaces[iface]:
        self.__interfaces[iface].destroy()
    self.__config_controls.clear()
    if self.__settings_dialog:
      self.__settings_dialog.destroy()
    StatusMenuItem.destroy(self)
    worker.get().shutdown()
    print '\n%s: destroyed' % (self.__class__.__name__)

  def __init_iface(self, iface):
    return iface(self.__bus, self.process_sai, self.__show_settings_dialog)

  def __setup_buttons(self):
    #with self.__ui_lock:
#    self.__smi_box.attach(self.__interfaces[iface].get_button(),
#                                ind, ind + 1, 0, 1,
#                                gtk.EXPAND | gtk.FILL,
#                                gtk.SHRINK)
    #button = self.__interfaces[iface].get_button()
    #self.__smi_box.pack_start(button)
    #position = min(len(self.__smi_box.get_children()) - 1, self.__interfaces[iface].position)
    #self.__smi_box.reorder_child(button, position)
    children = self.__smi_box.get_children()
    for child in children:
      self.__smi_box.remove(child)
    for iface in self.__available_ifaces:
      iface_obj = self.__interfaces[iface.name.lower()]
      if iface_obj:
        self.__smi_box.pack_start(iface_obj.get_button())

  def __settings_button_clicked(self, button):
    button.get_toplevel().hide()
    gobject.idle_add(self.__show_settings_dialog, button)

  def __show_settings_dialog(self, button=None):
    self.__config.load()
    config_keys = [key for key in self.__config.get_keys() 
                   if key.startswith('settings')]
    if self.__settings_dialog == None:
      self.__settings_dialog = gtk.Dialog(self.app_name, None,#self.window, 
                                        gtk.DIALOG_MODAL | gtk.DIALOG_NO_SEPARATOR, 
                                        self.__config_ui.get_dialog_buttons())
      wpa = gtk.VBox()
      self.__config_controls = {}
      config_keys_controls = set(config_keys)
      for iface in self.__available_ifaces:
        iface_name = iface.name
        iface_key = iface_name.lower()
        wpa.pack_start(gtk.Label('%s' % iface_name))
        iface_keys = set(key for key in config_keys_controls 
                         if key.startswith('settings/%s/' % (iface_key)))
        config_keys_controls -= iface_keys
        iface_keys = list(iface_keys)
        iface_keys.sort()
        for config_key in iface_keys:
          name, ck_type, value = self.__config.get_entry(config_key)
          config_options = self.__config.get_option(config_key)
          options = ()
          if config_options:
            options = zip(map(self.__lcl.get_item, config_options),
                          config_options)
          config_control = self.__config_ui.create_control(self.__lcl.get(config_key.replace('settings/%s/' % (iface_key),'',1)), 
                                                           ck_type, 
                                                           (self.__lcl.get_item(str(value)), 
                                                            value), 
                                                           options)
          if config_control:
            self.__config_controls[config_key] = config_control
            wpa.pack_start(config_control, False)
      if config_keys_controls:
        wpa.pack_start(gtk.Label(self.__lcl.get('settings-other')))
        for config_key in config_keys_controls:
          name, ck_type, value = self.__config.get_entry(config_key)
          config_options = self.__config.get_option(config_key)
          options = ()
          if config_options:
            options = zip(map(self.__lcl.get, config_options), config_options)
          config_control = self.__config_ui.create_control(self.__lcl.get(config_key), 
                                                           ck_type, 
                                                           (self.__lcl.get_item(str(value)), 
                                                            value), 
                                                           options)
          if config_control:
            self.__config_controls[config_key] = config_control
            wpa.pack_start(config_control, False)
      about_page = gtk.VBox()
      about_page.pack_start(gtk.Label('%s %s' % (self.app_name, self.version)))
      about_page.pack_start(gtk.Label('%s%s %s <%s>' % (u'\u00A9', 
                                                        self.dev_years, 
                                                        self.dev_author, 
                                                        self.dev_email)))
      notebook = NotebookMaemo5()
      notebook.set_box(self.__settings_dialog.vbox)
      notebook.append_pages(([[self.__gtk_swr.get_text(gtk.STOCK_PREFERENCES), 
                               wpa], 
                              [self.__gtk_swr.get_text(gtk.STOCK_ABOUT), 
                               about_page]]))
      self.__settings_dialog.vbox.show_all()
      notebook.set_active(0)
#    settings_dialog.vbox.set_size_request(-1, min(350, notebook.get_height()))
    self.__settings_dialog.show()
    #notebook.set_active(0)
    response = self.__settings_dialog.run()

    if response == gtk.RESPONSE_OK:
      controls_keys = self.__config_controls.keys()
      for config_key in config_keys:
        if config_key in controls_keys:
          name, ck_type, value = self.__config.get_entry(config_key)
          value = self.__config_ui.get_value(self.__config_controls[config_key],
                                             value, ck_type)
          self.__config.set_value(config_key, value, True, self.__config_callback)
      #self.__config.save()
      for iface in self.__interfaces:
        if self.__interfaces[iface]:
          self.__interfaces[iface].update()
    self.__settings_dialog.hide()
    return False

  def __config_callback(self, key, old_value, new_value):
    if old_value != new_value:
      if key.startswith('settings'):
        iface_match = self.__iface_config_re.match(key)
        if iface_match:
          iface = iface_match.group(1)
          if iface in self.__interfaces:
            subkey = key.replace('settings/%s/' % iface, '', 1)
            if subkey == 'enabled':
              if new_value:
                iface_class = None
                for a_iface_class in self.__available_ifaces:
                  if a_iface_class.name.lower() == iface:
                    iface_class = a_iface_class
                    break
                if iface_class:
                  if not self.__interfaces[iface]:
                    self.__interfaces[iface] = self.__init_iface(iface_class)
              else:
                self.__smi_box.remove(self.__interfaces[iface].get_button())
                if not len(self.__smi_box.get_children()):
                  self.__settings_button.show()
            if self.__interfaces[iface]:
              self.__interfaces[iface].config_changed(
                subkey, old_value, new_value)
              if subkey == 'enabled'and new_value:
                self.__settings_button.hide()
                self.__setup_buttons()
                self.__interfaces[iface].get_button().show_all()

  def process_sai(self, iname, image='', add=True):
    if add:
      try:
        self.__sai_animator.remove_image(self.__animation_images[iname])
      except:
        pass
      self.__animation_images[iname] = image
      self.__sai_animator.add_image(image)
    else:
      try:
        image = self.__animation_images[iname]
        self.__sai_animator.remove_image(image)
      except:
        pass

  def __set_sai(self, key):
    self.set_status_area_icon(self.__sai_cacher.get(key))

def get_hd_plugin_type(): return AdvancedInterfaceSwitcherMaemo5
