#
# Copyright 2011 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import cairo
import string

from textwriter import TextWriter

def shift_unicode(string, offset):
    ret = u""
    for c in string :
        if c != " " :
            ret += unichr(ord(c) + offset)
    return ret

def to_klingon_digits(text):
    text = text.upper()
    text = string.replace(text, ".", "=")
    text = string.replace(text, ":", "=")
    text = string.replace(text, "/", "=")
    text = string.replace(text, "-", "=")
    if not text.startswith("A") and not text.startswith("P") :
        return shift_unicode(text, 0xF8C0)
    else :
        return shift_unicode(text, 0xF88F)

class CairoTextWriter(TextWriter):
    def __init__(self, text_scaling, font_name, fill):
        TextWriter.__init__(self)
        self.text_scaling = text_scaling
        self.font_name = font_name
        self.fill = fill

    def calculate_text_width(self, text, font_size = 45):
        factor = 1.1

        self.context.set_font_size(int(self.text_scaling * font_size))
        
        if (self.font_name is not None) and self.font_name.startswith("Klingon") :
            text = to_klingon_digits(text)
            factor = 1.05

        return self.context.text_extents(text)[2] * factor

    def draw_text(self, text, font_size = 45, x = 0, y = 35):
        self.context.set_font_size(int(self.text_scaling * font_size))
        self.context.move_to(x, y)

        if (self.font_name is not None) and self.font_name.startswith("Klingon") :
            text = to_klingon_digits(text)

        self.context.text_path(text)
        if self.fill :
            self.context.fill()
        else :
            self.context.stroke()

