#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import cairo
from datetime import datetime
import gtk
import math

import clock

def get_name():
    return "Decimal Clock"

class DecimalClock(clock.Clock):
    def draw_clock(self):
        h = self.time.hour
        if self.twelve_hour_mode :
            abrv = "AM"
            if h == 0 :
                h = 12
            elif h == 12 :
                abrv = "PM"
            elif h > 12 :
                h = h % 12
                abrv = "PM"

        if self.pad_zeros :
            fill_char = '0'
        else :
            fill_char = ' '

        text = str(h).rjust(2, fill_char) + ":" + str(self.time.minute).zfill(2)
        if self.show_seconds :
            text = text + ":" + str(self.time.second).zfill(2)
        
        self.draw_text(text)

        if self.twelve_hour_mode :
            self.draw_text(abrv, 20, self.text_width)

    def resize(self):
        if self.show_seconds :
            text = "22:22:22"
        else:
            text = "22:22"

        self.text_width = self.calculate_text_width(text)

        if self.twelve_hour_mode :
            self.abrv_width = self.calculate_text_width("AM", 20)
        else :
            self.abrv_width = 0

        self.drawing_area.set_size_request(int(self.text_width + self.abrv_width), 36)

    def resize_alarm_enabled(self):
        if not self.twelve_hour_mode :
            clock.Clock.resize_alarm_enabled(self)

