/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Advanced Clock Plugin.
 *
 *  Advanced Clock Plugin is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Advanced Clock Plugin is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Advanced Clock Plugin.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DIALOG_H
#define DIALOG_H

#ifdef Q_WS_MAEMO_5
#include <gq/gconfitem.h>
#endif

#include <QColor>
#include <QDialog>
#include <QStringList>

class GConfItem;

namespace Ui {
    class Dialog;
}

class Dialog : public QDialog
{
    Q_OBJECT

public:
    explicit Dialog(int viewId = -1, QWidget *parent = 0);
    ~Dialog();

    void accept();

    const static QString GCONF_PATH;
    const static QString GCONF_PATH_CLOCK;

public slots:
    void updateColor(QColor color);

private:
    Ui::Dialog *ui;
    void fileSelected(QString fileName);

#ifdef Q_WS_MAEMO_5
    int viewId;
    QString gconfClockName;
    QString gconfClockPath;

    GConfItem *clockName;
    GConfItem *showSeconds;
    GConfItem *twelveHourMode;
    GConfItem *fill;
    GConfItem *showAlarmIndicator;
    GConfItem *colorR;
    GConfItem *colorG;
    GConfItem *colorB;
    GConfItem *fontName;
    GConfItem *textScaling;
    GConfItem *padZeros;

    GConfItem *city;
    GConfItem *country;
    GConfItem *offset;
    GConfItem *timeZone;

    GConfItem *customFormat;
    GConfItem *alarmIndicatorIcon;

    GConfItem *clockPerDesktop;

    GConfItem *useDigitImages;
    GConfItem *digitImageSet;

    QStringList cityNames;
    QStringList countryNames;
    QStringList timeZones;
#endif

private slots:
    void fileDialog();

};

#endif // DIALOG_H
