#
# Copyright 2011 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import gtk
import os

from pixbufanimationplayer import PixbufAnimationPlayer
from textwriter import TextWriter

class GtkPixbufTextWriter(TextWriter):
    def __init__(self, text_scaling, image_path):
        TextWriter.__init__(self)
        self.text_scaling = text_scaling

        image_file_names = os.listdir(image_path)
        absolute_image_paths = map(lambda x: image_path + x, image_file_names)

        self.image_names = map(lambda x: os.path.splitext(x)[0], image_file_names)
        self.images = map(gtk.gdk.PixbufAnimation, absolute_image_paths)
        
        self.last_animated_string = None

    def calculate_text_width(self, text, font_size = 45):
        width = 0
        scaling = font_size / 45.0

        for c in text :
            pba = self.char_to_pixbufanimation(c)
            width += int(pba.get_width() * scaling)

        return width

    def char_to_pixbufanimation(self, c, static = False):
        if c == ":" :
            c = "colon"
        elif c == "-" :
            c = "dash"
        elif c == "." :
            c = "period"
        elif c == " " :
            c = "space"

        if static :
            c += "_static"

        return self.images[self.image_names.index(c)]

    def draw_pixbuf(self, pixbuf, x, y, scaling):
        if scaling == 1.0 :
            self.drawable.draw_pixbuf(self.gc, pixbuf, 0, 0, x, y - pixbuf.get_height())
        else :
            scaled_pixbuf = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, True, 8, int(pixbuf.get_width() * scaling), int(pixbuf.get_height() * scaling))
            pixbuf.scale(scaled_pixbuf, 0, 0, scaled_pixbuf.get_width(), scaled_pixbuf.get_height(), 0, 0, scaling, scaling, gtk.gdk.INTERP_BILINEAR)
            self.drawable.draw_pixbuf(self.gc, scaled_pixbuf, 0, 0, x, y - scaled_pixbuf.get_height())

    def draw_text(self, text, font_size = 45, x = 0, y = 0):
        animated = False
        current_x = x
        scaling = font_size / 45.0

        for i in range(len(text)) :
            pba = self.char_to_pixbufanimation(text[i])
            
            if pba.is_static_image() :
                self.draw_pixbuf(pba.get_static_image(), current_x, y, scaling)
            else :
                animated = True

                if (self.last_animated_string is None) or (self.last_animated_string[i] != text[i]) :
                    PixbufAnimationPlayer(pba, current_x, y, scaling, self)
                else :
                    pb = self.char_to_pixbufanimation(text[i], True)
                    self.draw_pixbuf(pb.get_static_image(), current_x, y, scaling)

            current_x += int(pba.get_width() * scaling)

        if animated :
            self.last_animated_string = text

