#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import cairo
from datetime import datetime
import gtk
import math
import pango

import clock

def get_name():
    return "Date Time Clock"

class DateTimeClock(clock.Clock):
    def draw_clock(self):
        self.context.set_font_size(int(self.text_scaling * 20))

        if self.pad_zeros :
            fill_char = '0'
        else :
            fill_char = ' '


# Draw date.
        self.context.move_to(2, 16)
        text = str(self.time.day).rjust(2, fill_char) + "." + str(self.time.month).rjust(2, fill_char) + "."
        if self.show_seconds :
            y = str(self.time.year)
            if not self.twelve_hour_mode :
                y = y[2:4]
            text = text + y
        
        if (self.font_name is not None) and self.font_name.startswith("Klingon") :
            text = clock.to_klingon_digits(text)

        self.context.text_path(text)

        if self.fill :
            self.context.fill()
        else :
          self.context.stroke()

# Draw time.
        self.context.move_to(2, 35)

        h = self.time.hour
        if self.twelve_hour_mode :
            abrv = "AM"
            if h == 0 :
                h = 12
            elif h == 12 :
                abrv = "PM"
            elif h > 12 :
                h = h % 12
                abrv = "PM"

        text = str(h).rjust(2, fill_char) + ":" + str(self.time.minute).zfill(2)
        if self.show_seconds :
            text = text + ":" + str(self.time.second).zfill(2)
        
        if (self.font_name is not None) and self.font_name.startswith("Klingon") :
            text = clock.to_klingon_digits(text)
            if self.twelve_hour_mode :
                abrv = clock.to_klingon_text(abrv)

        self.context.text_path(text)

        if self.fill :
            self.context.fill()
        else :
          self.context.stroke()

        if self.twelve_hour_mode :
            self.context.set_font_size(int(self.text_scaling * 10))
            self.context.move_to(self.text_width, 35)
            
            self.context.text_path(abrv)

            if self.fill :
                self.context.fill()
            else :
                self.context.stroke()

    def resize(self):
        factor = 1.1
        abrv = "AM"
        self.context.set_font_size(int(self.text_scaling * 20))
      
        if self.show_seconds :
            text = "00:00:00"
        else:
            text = "00:00"

        if (self.font_name is not None) and self.font_name.startswith("Klingon") :
            text = clock.to_klingon_digits(text)
            abrv = clock.to_klingon_text(abrv)
            factor = 1.05

        self.text_width = self.context.text_extents(text)[2]
        self.text_width *= factor

        if self.twelve_hour_mode :
            self.text_width += self.context.text_extents("..")[2]
            self.context.set_font_size(int(self.text_scaling * 10))
            self.abrv_width = self.context.text_extents(abrv)[2]
            self.abrv_width *= factor
        else :
            self.abrv_width = 0

        self.drawing_area.set_size_request(int(self.text_width + self.abrv_width), 36)

