#ifndef TRACKERDIALOG_H
#define TRACKERDIALOG_H

#include <QDialog>
#include <QSettings>
#include <QDate>

namespace Ui {
    class TrackerDialog;
}

class TrackerDialog : public QDialog {
    Q_OBJECT
public:
    TrackerDialog(QWidget *parent = 0);
    ~TrackerDialog();
    QSettings mSelFood;
//    void setDate(QString sDate);
    void setDate(QDate dDate);
    void saveDate(QDate dDate);

protected:
    void changeEvent(QEvent *e);
    void setButtons(bool enabled);
    double dAllowance;
    void calcTotals();


private:
    Ui::TrackerDialog *ui;

private slots:
    void on_btnClose_clicked();
    void on_btnSave_clicked();
    void on_txtDate_dateChanged(QDate date);
    void on_txtBonus_valueChanged(double );
    void on_txtSnacks_valueChanged(double );
    void on_txtDinner_valueChanged(double );
    void on_txtLunch_valueChanged(double );
    void on_txtBreakfast_valueChanged(double );
//    void on_btnUpdate_clicked();
    void on_btnEdit_clicked();
};

#endif // TRACKERDIALOG_H
