/*
 * Created: 01/14/10-23:12:49
 * Author: Stephen
 */
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QSettings>
#include "fooddialog.h"
#include "storefood.h"
#include "trackeysummary.h"
#include "configdialog.h"
#include "weighttrackdialog.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();
    QSettings mSelFood;

protected:
    void changeEvent(QEvent *e);
    double getPoints(int iCals, int iFat);
    double getPoints();


private:
    Ui::MainWindow *ui;
    FoodDialog *foodDialog;
    StoreFood *storeFoodDialog;
    ConfigDialog *configDialog;
    TrackeySummary *trackeySummary;
    WeightTrackDialog *weightTracker;

private slots:
    void on_btnDonate_clicked();
    void on_btnHelp_clicked();
    void on_btnWeight_clicked();
    void on_btnConfig_clicked();
    void on_toolButton_3_clicked();
    void on_toolButton_2_clicked();
    void on_toolButton_clicked();
    void on_pushButton_10_clicked();
    void on_pushButton_clicked();
    void on_btnStore_clicked();
    void on_btnFoodLookup_clicked();
    void on_pushButton_Clear_clicked();
    void on_pushButton_Del_clicked();
    void on_pushButton_Dot_clicked();
    void on_pushButton_0_clicked();
    void on_pushButton_9_clicked();
    void on_pushButton_8_clicked();
    void on_pushButton_7_clicked();
    void on_pushButton_6_clicked();
    void on_pushButton_5_clicked();
    void on_pushButton_4_clicked();
    void on_pushButton_3_clicked();
    void on_pushButton_2_clicked();
    void on_pushButton_1_clicked();
    void on_pushButton_Go_clicked();
};

#endif // MAINWINDOW_H
