/*
 * Copyright (C) 2010 Felipe Zimmerle <felipe.zimmerle@collabora.co.uk>
 *
 * This file is part of 4x4 inclinometer.
 *
 * 4x4 inclinometer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * 4x4 inclinometer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Part of the code used on the animations cames from:
 * http://wiki.forum.nokia.com/index.php/CS001558_-_Animating_graphics_item_rotation
 * (CS001558 - Animating graphics item rotation)
 *
 */

#ifndef PICTUREITEM_H
#define PICTUREITEM_H

#include <QObject>
#include <QtCore>
#include <QtGui>

class PictureItem : public QObject, public QGraphicsPixmapItem
{

    Q_OBJECT

    Q_PROPERTY(qreal rotationAngle READ rotationAngle WRITE setRotationAngle)

public:
    PictureItem(const QPixmap &pix, QGraphicsScene *scene);

    void setRotationAngle(qreal);
    qreal rotationAngle() const;

    void animateAngle(int, int);
    void animateToAngle(int);

    bool animationInPlace;

public slots:
    void animationFinished();

private:
    qreal m_rotationAngle;
    QPropertyAnimation* anim;


};

#endif // PICTUREITEM_H
