/*
 * Copyright 2010  Open Source & Linux Lab (OSLL)  maemo@osll.spb.ru
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * The advertising clause requiring mention in adverts must never be included.
 */

/* $Id$ */
/*!
 * \file MainWindow.h
 * \brief Header of MainWindow
 * \todo add comment here
 *
 * File description
 *
 * PROJ: 15shki
 * ---------------------------------------------------------------- */


#ifndef _MainWindow_H_BDA1E014_9E83_4146_B183_B32D268E9448_INCLUDED_
#define _MainWindow_H_BDA1E014_9E83_4146_B183_B32D268E9448_INCLUDED_

#include <QMainWindow>
#include <QDialog>
#include <QPushButton>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QLabel>
#include <QMenu>
#include <QMenuBar>

#include "Game.h"

 /*!
   * Class description. May use HTML formatting
   *
   */
class MainWindow : public QMainWindow
{
    Q_OBJECT

    Game *game;
    int fullscreen;

  public:
    MainWindow(QWidget *parent = 0);
    //MainWindow(int width, int height, QWidget *parent = 0);

    void setScreen(int width, int height);

    ~MainWindow()
    {
    }

    Game * getGame()
    {
        return game;
    }

protected:
    void mousePressEvent(QMouseEvent *event);

public slots:
    void newGame();
    void onMovementsChanged(int movements);
    void onDurationChanged(int duration);

  private:

      QAction *newAction;
      QAction *exitAction;
      QMenu *fileMenu;
      QLabel *scoreLabel;
      QLabel *timeLabel;
      //QHBoxLayout *mainLayout;
      //QVBoxLayout *buttonsLayout;

    //MainWindow(const MainWindow& obj);
    //MainWindow& operator=(const MainWindow& obj);

}; // class MainWindow

#endif //_MainWindow_H_BDA1E014_9E83_4146_B183_B32D268E9448_INCLUDED_

/* ===[ End of file $HeadURL$ ]=== */
