/*
 * Copyright 2010  Open Source & Linux Lab (OSLL)  maemo@osll.spb.ru
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * The advertising clause requiring mention in adverts must never be included.
 */

/*! ---------------------------------------------------------------
 * $Id$
 *
 * \file Model.cpp
 * \brief Model implementation
 *
 * File description
 *
 * PROJ: 15shki
 * ---------------------------------------------------------------- */

#include "Model.h"
#include <QObject>
#include <QDebug>

Model::Model(const int *newArray)
{
    if (newArray == 0)
    {

        for (int i = 0; i < 15; i++)
        {
            array[i] = i + 1;
        }
        array[15] = 0;
    }
    else
    {
        for (int i = 0; i < 16; i++)
            array[i] = newArray[i];
    }
    state = -1; /* undefined posiotion of the device */
}

Model::~Model()
{}

void Model::setArray(const int *newArray)
{
    if (newArray != 0)
        for (int i = 0; i < 16; i++)
            array[i] = newArray[i];
    qDebug("Model: array has been set");
}

const int* Model::getArray()
{
    return array;
}

int defineTilt(double beta, double gamma)
{
    int retValue = -1;

    if ((beta > 77) &&
        (beta < 103) &&
        (gamma > -13) &&
        (gamma < 13))
    {
        retValue = 0;
    }
    else if ((beta < 0) ||
             (beta > 180) ||
             (gamma < -90) ||
             (gamma > 90))

    {
        retValue = -2;
    }
    else if ((beta <= 75) &&
             (beta >= 0) &&
             ((90 - beta) > qAbs(gamma)))
    {
        retValue = 4; /* tilted down */
    }
    else if ((beta >= 105) &&
             (beta <= 180) &&
             ((beta - 90) > qAbs(gamma)))
    {
        retValue = 2; /* tilted to the up */
    }
    else if ((gamma >= 15) &&
             (gamma <= 90) &&
             (gamma > qAbs(90 - beta)))
    {
        retValue = 3; /* tilted right */
    }
    else if ((gamma <= -15) &&
             (gamma >= -90) &&
             (qAbs(gamma) > qAbs(90 - beta)))
    {
        retValue = 1; /* tilted left */
    }
    else
    {
        retValue = -3; /* other error */
    }

    return retValue;
}

int Model::setNewAngles(double beta, double gamma)
{
    int retValue = 0;

    this->beta = beta;
    this->gamma = gamma;
    int tilt = defineTilt(beta, gamma);
    if (state == -1)
    {
        if (tilt > 0)
        {
            state = 1;
        }
        else if (tilt == 0)
        {
            state = 0;
        }
    }
    else if (state == 0)
    {
        if (tilt > 0)
        {
            state = 1;
            /* do shake */
            switch (tilt)
            {
            case 1:
                retValue = shakeLeft();
                break;
            case 2:
                retValue = shakeUp();
                break;
            case 3:
                retValue = shakeRight();
                break;
            case 4:
                retValue = shakeDown();
                break;
            default:
                qDebug() << "WRONG direction to shake";
                break;
            }
        }
    }
    else if (state == 1)
    {
        if (tilt == 0)
        {
            state = 0;
        }
    }
    else
        qDebug() << "WRONG state in Model!";

    return retValue;

}

int Model::checkFinished()
{
    for (int i = 0; i < 15; i++)
    {
        if (array[i] != i + 1)
            return 0;
    }
    return 1;
}

int Model::findFree()
{
    for (int i = 0; i < 16; i++)
        if (array[i] == 0)
            return i;
    return -1;
}

int Model::shakeLeft()
{
    int i = findFree();
    if ((i % 4) != 3) /* not last column */
    {
        array[i] = array[i+1];
        array[i+1] = 0;
        emit shifted(array[i], i+1, i);
        if (checkFinished())
            emit finished();
        return 1;
    }

    return 0;
}

int Model::shakeRight()
{
    int i = findFree();
    if ((i % 4) != 0) /* not first column */
    {
        array[i] = array[i-1];
        array[i-1] = 0;
        emit shifted(array[i], i-1, i);
        if (checkFinished())
            emit finished();
        return 1;
    }

    return 0;
}

int Model::shakeUp()
{
    int i = findFree();
    if (i < 12) /* not last row */
    {
        array[i] = array[i+4];
        array[i+4] = 0;
        emit shifted(array[i], i+4, i);
        if (checkFinished())
            emit finished();
        return 1;
    }

    return 0;
}

int Model::shakeDown()
{
    int i = findFree();
    if (i > 3) /* not first row */
    {
        array[i] = array[i-4];
        array[i-4] = 0;
        emit shifted(array[i], i-4, i);
        if (checkFinished())
            emit finished();
        return 1;
    }

    return 0;
}





/* ===[ End of file $HeadURL$ ]=== */
