/*
 * Copyright 2010  Open Source & Linux Lab (OSLL)  maemo@osll.spb.ru
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * The advertising clause requiring mention in adverts must never be included.
 */

/* $Id$ */
/*!
 * \file Model.h
 * \brief Header of Model
 * \todo add comment here
 *
 * File description
 *
 * PROJ: 15shki
 * ---------------------------------------------------------------- */


#ifndef _Model_H_72195EFD_9022_46B8_ABB1_F2E7DDCF1126_INCLUDED_
#define _Model_H_72195EFD_9022_46B8_ABB1_F2E7DDCF1126_INCLUDED_

#include <QObject>

    /*!
     * It contains array which represent game place and 16 fields.
     * Each element of the array takes number from 0 to 15.
     * Number 0 means that field is free.
     *
     * We can try to "shake" the game place and some number can
     * be shifted if there is a free field in the correct direction
     *
     * If game place was changed (some number was shifted)
     * then object emits signal "shifted" with
     * new array as a parameter
     *
     */
class Model : public QObject
{
    Q_OBJECT

  private:
    int array[16];
    double beta;
    double gamma;
    int state; /* -1 - undefined position of the device;
                   0 - device is not tilted;
                   1 - device is tilted */

  public:
    Model(const int *newArray = 0);
    ~Model();

    void setArray(const int *newArray);
    const int* getArray();
    int setNewAngles(double beta, double gamma);

    int shakeLeft();
    int shakeRight();
    int shakeUp();
    int shakeDown();

    int findFree();

  private:
    int checkFinished();


  signals:
    void shifted(int number, int oldField, int newField);
    void finished();


  private:
        //Model(const Model& obj);
        //Model& operator=(const Model& obj);

}; // class Model

// } // namespace nsModel

#endif //_Model_H_72195EFD_9022_46B8_ABB1_F2E7DDCF1126_INCLUDED_

/* ===[ End of file $HeadURL$ ]=== */
