#!/usr/bin/perl -w
#
# Copyright (C) 2009 Adam Dingle <adam@yorba.org>
#
# This file is part of WebKit
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
# 
# You should have received a copy of the GNU Library General Public License
# aint with this library; see the file COPYING.LIB.  If not, write to
# the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA 02110-1301, USA.
# 

my $classlist = <STDIN>;
chomp($classlist);
my @classes = split / /, $classlist;
@classes = sort @classes;

print <<EOF;
/* This file is part of the WebKit open source project.
   This file has been generated by gobject-generate.pl.  DO NOT MODIFY!
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

EOF

my $outType = $ARGV[0];
my $header;
if ($outType eq "defines") {
    $header = "webkitdomdefines_h";
} elsif ($outType eq "webkitdom") {
    $header = "webkitdom_h";
} else {
    die "unknown output type";
}

print "#ifndef ${header}\n";
print "#define ${header}\n";
print "\n";

if ($outType eq "defines") {
    foreach my $class (@classes) {
        print "typedef struct _WebKit${class} WebKit${class};\n";
        print "typedef struct _WebKit${class}Class WebKit${class}Class;\n";
        print "\n";
    }
} elsif ($outType eq "webkitdom") {
    foreach my $class (@classes) {
        print "#include <webkit/WebKit${class}.h>\n";
    }
}

print "\n";
print "#endif\n";


