/*
 *  Copyright (C) 1999-2001 Harri Porten (porten@kde.org)
 *  Copyright (C) 2003, 2004, 2005, 2006, 2008 Apple Inc. All rights reserved.
 *  Copyright (C) 2007 Samuel Weinig <sam@webkit.org>
 *  Copyright (C) 2008 Luke Kenneth Casson Leighton <lkcl@lkcl.net>
 *  Copyright (C) 2008 Martin Soto <soto@freedesktop.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef WEBKIT_BINDING_H
#define WEBKIT_BINDING_H

#include <wtf/Noncopyable.h>

#include "CanvasPixelArray.h"
#include "CSSRule.h"
#include "CSSValue.h"
#include "Document.h"
#include "DOMWindow.h"
#include "Element.h"
#include "HTMLCollection.h"
#include "Node.h"
#include "StyleSheet.h"
#include "Text.h"

namespace WebCore {

    class AtomicString;
    class Document;
    class Event;
    class Frame;
    class KURL;
    class Node;
    class String;

#if ENABLE(SVG)
    class SVGElement;
#endif
} // namespace WebCore

namespace WebKit {
    gpointer toGDOM(WebCore::CanvasPixelArray* node);
    gpointer toGDOM(WebCore::CSSRule* node);
    gpointer toGDOM(WebCore::CSSValue* node);
    gpointer toGDOM(WebCore::Document* node);
    gpointer toGDOM(WebCore::DOMWindow* node);
    gpointer toGDOM(WebCore::Element* node);
    gpointer toGDOM(WebCore::HTMLCollection* node);
    gpointer toGDOM(WebCore::Node* node);
    gpointer toGDOM(WebCore::StyleSheet* node);
    gpointer toGDOM(WebCore::Text* node);

    class GDOMObjectCache {
    public:
        static gpointer getDOMObject(void *objectHandle);
        static gpointer putDOMObject(void *objectHandle, gpointer wrapper);
        static void forgetDOMObject(void *objectHandle);
    };
} // namespace WebKit

#endif // WEBKIT_BINDING_H
