/*
 *  Copyright (C) 2006 George Staikos <staikos@kde.org>
 *  Copyright (C) 2006 Alexey Proskuryakov <ap@nypop.com>
 *  Copyright (C) 2007 Apple Computer, Inc. All rights reserved.
 *  Copyright (C) 2008 Jürg Billeter <j@bitron.ch>
 *  Copyright (C) 2008 Dominik Röttsches <dominik.roettsches@access-company.com>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef CasefoldTableFromGLib_h
#define CasefoldTableFromGLib_h

#include <glib.h>

// copied from GLib

/* Table of casefolding cases that can't be derived by lowercasing
 */
static const struct {
    guint16 ch;
    gchar data[7];
} casefold_table[] = {
    { 0x00b5, "\xce\xbc" },
    { 0x00df, "\x73\x73" },
    { 0x0130, "\x69\xcc\x87" },
    { 0x0149, "\xca\xbc\x6e" },
    { 0x017f, "\x73" },
    { 0x01f0, "\x6a\xcc\x8c" },
    { 0x0345, "\xce\xb9" },
    { 0x0390, "\xce\xb9\xcc\x88\xcc\x81" },
    { 0x03b0, "\xcf\x85\xcc\x88\xcc\x81" },
    { 0x03c2, "\xcf\x83" },
    { 0x03d0, "\xce\xb2" },
    { 0x03d1, "\xce\xb8" },
    { 0x03d5, "\xcf\x86" },
    { 0x03d6, "\xcf\x80" },
    { 0x03f0, "\xce\xba" },
    { 0x03f1, "\xcf\x81" },
    { 0x03f5, "\xce\xb5" },
    { 0x0587, "\xd5\xa5\xd6\x82" },
    { 0x1e96, "\x68\xcc\xb1" },
    { 0x1e97, "\x74\xcc\x88" },
    { 0x1e98, "\x77\xcc\x8a" },
    { 0x1e99, "\x79\xcc\x8a" },
    { 0x1e9a, "\x61\xca\xbe" },
    { 0x1e9b, "\xe1\xb9\xa1" },
    { 0x1f50, "\xcf\x85\xcc\x93" },
    { 0x1f52, "\xcf\x85\xcc\x93\xcc\x80" },
    { 0x1f54, "\xcf\x85\xcc\x93\xcc\x81" },
    { 0x1f56, "\xcf\x85\xcc\x93\xcd\x82" },
    { 0x1f80, "\xe1\xbc\x80\xce\xb9" },
    { 0x1f81, "\xe1\xbc\x81\xce\xb9" },
    { 0x1f82, "\xe1\xbc\x82\xce\xb9" },
    { 0x1f83, "\xe1\xbc\x83\xce\xb9" },
    { 0x1f84, "\xe1\xbc\x84\xce\xb9" },
    { 0x1f85, "\xe1\xbc\x85\xce\xb9" },
    { 0x1f86, "\xe1\xbc\x86\xce\xb9" },
    { 0x1f87, "\xe1\xbc\x87\xce\xb9" },
    { 0x1f88, "\xe1\xbc\x80\xce\xb9" },
    { 0x1f89, "\xe1\xbc\x81\xce\xb9" },
    { 0x1f8a, "\xe1\xbc\x82\xce\xb9" },
    { 0x1f8b, "\xe1\xbc\x83\xce\xb9" },
    { 0x1f8c, "\xe1\xbc\x84\xce\xb9" },
    { 0x1f8d, "\xe1\xbc\x85\xce\xb9" },
    { 0x1f8e, "\xe1\xbc\x86\xce\xb9" },
    { 0x1f8f, "\xe1\xbc\x87\xce\xb9" },
    { 0x1f90, "\xe1\xbc\xa0\xce\xb9" },
    { 0x1f91, "\xe1\xbc\xa1\xce\xb9" },
    { 0x1f92, "\xe1\xbc\xa2\xce\xb9" },
    { 0x1f93, "\xe1\xbc\xa3\xce\xb9" },
    { 0x1f94, "\xe1\xbc\xa4\xce\xb9" },
    { 0x1f95, "\xe1\xbc\xa5\xce\xb9" },
    { 0x1f96, "\xe1\xbc\xa6\xce\xb9" },
    { 0x1f97, "\xe1\xbc\xa7\xce\xb9" },
    { 0x1f98, "\xe1\xbc\xa0\xce\xb9" },
    { 0x1f99, "\xe1\xbc\xa1\xce\xb9" },
    { 0x1f9a, "\xe1\xbc\xa2\xce\xb9" },
    { 0x1f9b, "\xe1\xbc\xa3\xce\xb9" },
    { 0x1f9c, "\xe1\xbc\xa4\xce\xb9" },
    { 0x1f9d, "\xe1\xbc\xa5\xce\xb9" },
    { 0x1f9e, "\xe1\xbc\xa6\xce\xb9" },
    { 0x1f9f, "\xe1\xbc\xa7\xce\xb9" },
    { 0x1fa0, "\xe1\xbd\xa0\xce\xb9" },
    { 0x1fa1, "\xe1\xbd\xa1\xce\xb9" },
    { 0x1fa2, "\xe1\xbd\xa2\xce\xb9" },
    { 0x1fa3, "\xe1\xbd\xa3\xce\xb9" },
    { 0x1fa4, "\xe1\xbd\xa4\xce\xb9" },
    { 0x1fa5, "\xe1\xbd\xa5\xce\xb9" },
    { 0x1fa6, "\xe1\xbd\xa6\xce\xb9" },
    { 0x1fa7, "\xe1\xbd\xa7\xce\xb9" },
    { 0x1fa8, "\xe1\xbd\xa0\xce\xb9" },
    { 0x1fa9, "\xe1\xbd\xa1\xce\xb9" },
    { 0x1faa, "\xe1\xbd\xa2\xce\xb9" },
    { 0x1fab, "\xe1\xbd\xa3\xce\xb9" },
    { 0x1fac, "\xe1\xbd\xa4\xce\xb9" },
    { 0x1fad, "\xe1\xbd\xa5\xce\xb9" },
    { 0x1fae, "\xe1\xbd\xa6\xce\xb9" },
    { 0x1faf, "\xe1\xbd\xa7\xce\xb9" },
    { 0x1fb2, "\xe1\xbd\xb0\xce\xb9" },
    { 0x1fb3, "\xce\xb1\xce\xb9" },
    { 0x1fb4, "\xce\xac\xce\xb9" },
    { 0x1fb6, "\xce\xb1\xcd\x82" },
    { 0x1fb7, "\xce\xb1\xcd\x82\xce\xb9" },
    { 0x1fbc, "\xce\xb1\xce\xb9" },
    { 0x1fbe, "\xce\xb9" },
    { 0x1fc2, "\xe1\xbd\xb4\xce\xb9" },
    { 0x1fc3, "\xce\xb7\xce\xb9" },
    { 0x1fc4, "\xce\xae\xce\xb9" },
    { 0x1fc6, "\xce\xb7\xcd\x82" },
    { 0x1fc7, "\xce\xb7\xcd\x82\xce\xb9" },
    { 0x1fcc, "\xce\xb7\xce\xb9" },
    { 0x1fd2, "\xce\xb9\xcc\x88\xcc\x80" },
    { 0x1fd3, "\xce\xb9\xcc\x88\xcc\x81" },
    { 0x1fd6, "\xce\xb9\xcd\x82" },
    { 0x1fd7, "\xce\xb9\xcc\x88\xcd\x82" },
    { 0x1fe2, "\xcf\x85\xcc\x88\xcc\x80" },
    { 0x1fe3, "\xcf\x85\xcc\x88\xcc\x81" },
    { 0x1fe4, "\xcf\x81\xcc\x93" },
    { 0x1fe6, "\xcf\x85\xcd\x82" },
    { 0x1fe7, "\xcf\x85\xcc\x88\xcd\x82" },
    { 0x1ff2, "\xe1\xbd\xbc\xce\xb9" },
    { 0x1ff3, "\xcf\x89\xce\xb9" },
    { 0x1ff4, "\xcf\x8e\xce\xb9" },
    { 0x1ff6, "\xcf\x89\xcd\x82" },
    { 0x1ff7, "\xcf\x89\xcd\x82\xce\xb9" },
    { 0x1ffc, "\xcf\x89\xce\xb9" },
    { 0x2160, "\xe2\x85\xb0" },
    { 0x2161, "\xe2\x85\xb1" },
    { 0x2162, "\xe2\x85\xb2" },
    { 0x2163, "\xe2\x85\xb3" },
    { 0x2164, "\xe2\x85\xb4" },
    { 0x2165, "\xe2\x85\xb5" },
    { 0x2166, "\xe2\x85\xb6" },
    { 0x2167, "\xe2\x85\xb7" },
    { 0x2168, "\xe2\x85\xb8" },
    { 0x2169, "\xe2\x85\xb9" },
    { 0x216a, "\xe2\x85\xba" },
    { 0x216b, "\xe2\x85\xbb" },
    { 0x216c, "\xe2\x85\xbc" },
    { 0x216d, "\xe2\x85\xbd" },
    { 0x216e, "\xe2\x85\xbe" },
    { 0x216f, "\xe2\x85\xbf" },
    { 0x24b6, "\xe2\x93\x90" },
    { 0x24b7, "\xe2\x93\x91" },
    { 0x24b8, "\xe2\x93\x92" },
    { 0x24b9, "\xe2\x93\x93" },
    { 0x24ba, "\xe2\x93\x94" },
    { 0x24bb, "\xe2\x93\x95" },
    { 0x24bc, "\xe2\x93\x96" },
    { 0x24bd, "\xe2\x93\x97" },
    { 0x24be, "\xe2\x93\x98" },
    { 0x24bf, "\xe2\x93\x99" },
    { 0x24c0, "\xe2\x93\x9a" },
    { 0x24c1, "\xe2\x93\x9b" },
    { 0x24c2, "\xe2\x93\x9c" },
    { 0x24c3, "\xe2\x93\x9d" },
    { 0x24c4, "\xe2\x93\x9e" },
    { 0x24c5, "\xe2\x93\x9f" },
    { 0x24c6, "\xe2\x93\xa0" },
    { 0x24c7, "\xe2\x93\xa1" },
    { 0x24c8, "\xe2\x93\xa2" },
    { 0x24c9, "\xe2\x93\xa3" },
    { 0x24ca, "\xe2\x93\xa4" },
    { 0x24cb, "\xe2\x93\xa5" },
    { 0x24cc, "\xe2\x93\xa6" },
    { 0x24cd, "\xe2\x93\xa7" },
    { 0x24ce, "\xe2\x93\xa8" },
    { 0x24cf, "\xe2\x93\xa9" },
    { 0xfb00, "\x66\x66" },
    { 0xfb01, "\x66\x69" },
    { 0xfb02, "\x66\x6c" },
    { 0xfb03, "\x66\x66\x69" },
    { 0xfb04, "\x66\x66\x6c" },
    { 0xfb05, "\x73\x74" },
    { 0xfb06, "\x73\x74" },
    { 0xfb13, "\xd5\xb4\xd5\xb6" },
    { 0xfb14, "\xd5\xb4\xd5\xa5" },
    { 0xfb15, "\xd5\xb4\xd5\xab" },
    { 0xfb16, "\xd5\xbe\xd5\xb6" },
    { 0xfb17, "\xd5\xb4\xd5\xad" }
};


#endif

