
import gtk, hildon
import datetime
import config
from lib.mvc.view import View
from lib.mvc.widgets import *
from lib.util import tz

class SettingsView(View, ):
    LABEL_GAP = 2
    SIGN_ICON = 'data/img/ToshlSign.png'
    RIGHT_BUTTON_WIDTH = 180
    BUTTON_HEIGHT = 70
    GENERAL_PADDING = {'top': 10, 'bottom': 10, 'right': 20, 'left': 29}
    def _init_(self):
        self.setWidget(newWindow(title='Settings'))
        self._vbox = newVBox()
        self._parea = newPannableArea()
        self._parea.add_with_viewport(self._vbox)
        self.getWidget().add(self._parea)
        self._initAccount()
        self._initCurrency()
        self._initSync()
        self._initTags()
    def _initAccount(self):
        self._startCurrentBox()
        self._current.pack_start(newTitleLabel('Account Information'), fill=True)
        accInfo = newSwitcher()
        accInfoDefault = AccountInfo()
        accInfoLogged = LoginAccountInfo()
        accInfo.add_item('default', accInfoDefault)
        accInfo.add_item('logged', accInfoLogged)
        self.add(accInfo, 'account_info')
        self.add(accInfoDefault, 'account_info_default')
        self.add(accInfoDefault.getLoginButton(), 'login_button')
        self.add(accInfoDefault.getRegisterButton(), 'register_button')
        self.add(accInfoLogged, 'account_info_logged')
        self._current.pack_start(accInfo)
        self._endCurrentBox()
        self._vbox.pack_start(newSeparator(), fill=True, expand=False)
        self._vbox.pack_start(newGap(20), fill=True, expand=False)
    def _initCurrency(self):
        self._startCurrentBox()
        self._current.pack_start(newTitleLabel('Your Currency'))
        dropDown = DropDown('')
        self.add(dropDown, 'currency_dropdown')
        self._current.pack_start(hshrink(dropDown))
        self._endCurrentBox()
    def _initSync(self):
        self._startCurrentBox()
        self._sync = newVBox()
        self._sync.pack_start(newGap(30))
        self._sync.pack_start(newTitleLabel('Synchronisation'))
        self._sync.pack_start(newDescLabel('Sync with Toshl.com'))
        dropDown = DropDown('')
        self.add(dropDown, 'sync_dropdown')
        self._sync.pack_start(newGap(5))
        self._sync.pack_start(hshrink(dropDown))
        syncBox = newHBox()
        icon = newImage(from_file=config.joinRoot(self.SIGN_ICON))
        syncBox.pack_start(icon, expand=False, fill=False)
        self._syncLabel = newLabel(alignment=(0.0, 1.0), name='settings_desc')
        syncBox.pack_start(pad(self._syncLabel, bottom=3, left=5), expand=True, fill=True, padding=10)
        syncButton = newFingerButton(label='Sync now', size_request=(self.RIGHT_BUTTON_WIDTH, 70))
        self.add(syncButton, 'sync_button')
        syncBox.pack_end(syncButton, expand=False, fill=False, padding=0)
        self._sync.pack_start(newGap(10))
        self._sync.pack_start(syncBox)
        self._sync.pack_start(newGap(30))
        switcher = newSwitcher()
        self.add(switcher, 'sync_switcher')
        switcher.add_item('sync', self._sync)
        switcher.add_item('empty', newLabel())
        self._current.pack_start(switcher)
        self._endCurrentBox()
    def _initTags(self):
        self._startCurrentBox()
        tagsBox = newHBox()
        vbox = newVBox()
        vbox.pack_start(newTitleLabel('Tags'))
        self._tagsDesc = newDescLabel('You have 10 tags. Unused tags are automatically removed.')
        vbox.pack_start(self._tagsDesc)
        tagsBox.pack_start(vbox, expand=True, fill=True)
        tagsButton = newFingerButton(label='Edit Tags', size_request=(self.RIGHT_BUTTON_WIDTH, 70))
        self.add(tagsButton, 'tags_button')
        tagsBox.pack_end(tagsButton, expand=False)
        self._current.pack_start(tagsBox, fill=True)
        self._current.pack_start(newGap(30))
        self._endCurrentBox()
    def setSyncLabel(self, date):
        if date:
            hin = ("You haven't synced in over a week" if ((datetime.datetime.now() - date).days > 7) else '')
            self._syncLabel.set_markup(('Last sync on %s at %s\n%s' % (date.strftime(self.getApp().getAccount().getDateFormat()), date.strftime('%H:%M'), hin)))
        else:
            self._syncLabel.set_markup("You haven't synced at all\n")
    def setTagsLabel(self, count):
        self._tagsDesc.set_text(('You have %d tags. Unused tags are automatically removed.' % count))
    def showParea(self):
        self._parea.show_all()
    def _startCurrentBox(self):
        self._current = newVBox()
    def _endCurrentBox(self, curr=None):
        if not(curr):
            curr = self._current
        if curr:
            self._vbox.pack_start(pad(curr, **self.GENERAL_PADDING))

class AccountInfo(gtk.VBox, ):
    UNDER_DESC = 30
    OVER_BUTTON = 15
    BUTTON_WIDTH = 300
    def __init__(self):
        gtk.VBox.__init__(self)
        self.pack_start(newDescLabel('Set up sync with Toshl.com and get pretty graphs,\ndata export and backup for free.'))
        self.pack_start(newGap(self.UNDER_DESC))
        self._buttonBox = newHBox(True, 100)
        registerBox = newVBox()
        registerBox.pack_start(newTitleLabel("I'm new to Toshl"))
        registerBox.pack_start(newGap(self.OVER_BUTTON))
        self._registerButton = newFingerButton(label='Register', size_request=(self.BUTTON_WIDTH, 70))
        registerBox.pack_start(hshrink(self._registerButton))
        self._buttonBox.pack_start(registerBox)
        loginBox = newVBox()
        loginBox.pack_start(newTitleLabel('I already have an account'))
        loginBox.pack_start(newGap(self.OVER_BUTTON))
        self._loginButton = newFingerButton(label='Log in', size_request=(self.BUTTON_WIDTH, 70))
        loginBox.pack_start(hshrink(self._loginButton))
        self._buttonBox.pack_start(loginBox)
        self.pack_start(self._buttonBox)
        self.pack_start(newGap(20))
    def getRegisterButton(self):
        return self._registerButton
    def getLoginButton(self):
        return self._loginButton

class LoginAccountInfo(gtk.VBox, ):
    PRO_ICON = 'data/img/ToshlSettingsPro.png'
    def __init__(self):
        gtk.VBox.__init__(self)
        self.pack_start(newDescLabel('Logged in as'))
        hBox = newHBox()
        self._emailLabel = newLabel(text='', name='settings_email', alignment=(0.0, 0.5))
        hBox.pack_start(self._emailLabel, expand=False, fill=False)
        self._proImage = newImage(from_file=config.joinRoot(self.PRO_ICON))
        hBox.pack_start(self._proImage, expand=False, fill=False, padding=50)
        hBox.pack_start(newLabel(), expand=True, fill=True)
        self.pack_start(hBox)
        self._hbox = hBox
        self.pack_start(newGap(20))
    def setPro(self, pro):
        self._hbox.remove(self._proImage)
        if pro:
            self._hbox.pack_start(self._proImage, expand=False, fill=False, padding=50)
            self._hbox.reorder_child(self._proImage, 1)
        else:
            pass
    def setEmail(self, email):
        self._emailLabel.set_text(email)

class DropDown(hildon.Button, ):
    DROPDOWN_ICON = 'data/img/ToshlDropdownIcon.png'
    def __init__(self, label, **args):
        hildon.Button.__init__(self, (gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT), hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
        box = newHBox()
        self._label = newLabel(text=label, alignment=(0.0, 0.5))
        box.pack_start(self._label, expand=True, fill=True)
        image = newImage(from_file=config.joinRoot(self.DROPDOWN_ICON))
        box.pack_end(image, expand=False, fill=False)
        self.add(box)
        self._callback = None
        self._show = None
        self._active = 0
        self._destroyed = False
        self.connect('clicked', self.showDialog)
    def set_active(self, active):
        self._active = active
    def set_label_text(self, text):
        self._label.set_text(text)
    def connect_on_selected(self, callback):
        self._callback = callback
    def connect_on_show(self, callback):
        self._show = callback
    def callBack(self, item):
        if self._callback:
            self._callback(item)
            self._active = item
    def showDialog(self, widget, data=None):
        if self._show:
            self._destroyed = False
            dialog = self._show(self)
            dialog.get_selector().set_active(0, self._active)
            dialog.doShow()

class DropdownDialog(PickerDialogFake, ):
    def __init__(self, window, dropdown, title, **kwargs):
        PickerDialogFake.__init__(self, title, window)
        self.set_size_request(-1, 280)
        self._dropdown = dropdown
        self._shown = False
        self._selector = newTextTouchSelector()
        self._selector.connect('changed', self.onChange)
        self.set_selector(self._selector)
    def appendRow(self, name):
        self._selector.append_row(name)
    def onChange(self, widget, column, data=None):
        if (self._shown and (column == 0)):
            i = self._selector.get_active(0)
            if (i > -1):
                self._shown = False
                self.hide()
                self._dropdown.callBack(i)
            else:
                self._shown = False
                self.hide()
    def doShow(self):
        self._shown = True
        self.show_all()
def newTitleLabel(label, offset=True, **kwargs):
    label = newLabel(text=label, name='settings_title', alignment=(0.0, 0.5), **kwargs)
    return (wrap(label, newAlignment(padding=(0, SettingsView.LABEL_GAP, 0, 0), xscale=1.0, yscale=1.0)) if offset else label)
def newDescLabel(label, offset=False, **kwargs):
    label = newLabel(text=label, name='settings_desc', alignment=(0.0, 0.5), **kwargs)
    return (wrap(label, newAlignment(padding=(0, SettingsView.LABEL_GAP, 0, 0), xscale=1.0, yscale=1.0)) if offset else label)
def newGap(px, **kwargs):
    return newLabel(size_request=(-1, px))
def newSeparator():
    return wrap(newLabel(size_request=(-1, 2)), newEventBox(name='settings_separator'))
def hshrink(widget):
    box = newHBox()
    box.pack_start(widget, expand=False)
    box.pack_start(newLabel(), expand=True, fill=True)
    return box
