
import gtk, hildon
import datetime
import config
from lib.mvc.view import View
from lib.mvc.widgets import *
from lib.util import tz

class MainView(View, ):
    ADD_EXPENSE_PADDING = (10, 10, 10, 10)
    TAG_ICON = 'data/img/TagIcon.png'
    TIMELINE_ICON = 'data/img/TimelineIcon.png'
    def _init_(self):
        self.setWidget(newWindow(title='Toshl'))
        self._syncShown = False
        self._syncHandler = None
        self.getWidget().add(self.getView('area').getWidget())
        appm = newAppMenu()
        self.add(appm, 'app_menu')
        self.add(appm.add_filter('Timeline', config.joinRoot(self.TIMELINE_ICON), False), 'appm_timeline_radio')
        self.add(appm.add_filter('Tags', config.joinRoot(self.TAG_ICON)), 'appm_tags_radio')
        self.add(appm.add_button('Time span'), 'appm_timespan_button')
        self.add(appm.add_button('Settings'), 'appm_settings_button')
        appm.show_all()
        self.getWidget().set_app_menu(appm)
    def showSync(self):
        
        if not(self._syncShown):
            self.add(self.getWidget('app_menu').add_custom_button('Synchronize with Toshl.com'), 'appm_synchronize_button')
            self.getWidget('appm_synchronize_button').set_name('main_appm_synchronize_button')
            self._syncHandler = self.getWidget('appm_synchronize_button').connect('clicked', self.getCtrl().on_appm_synchronize_button_clicked)
            self.getWidget('app_menu').show_all()
            self._syncShown = True
    def hideSync(self):
        try:
            self.getWidget('appm_synchronize_button').disconnect(self._syncHandler)
        except:
            pass
        self.getWidget('app_menu').remove_custom_button(self.getWidget('appm_synchronize_button'))
        self.removeWidget('appm_synchronize_button')
        self.getWidget('app_menu').show_all()
        self._syncShown = False

class TimespanDialog(PickerDialogFake, ):
    def __init__(self, view, custom=False, **kwargs):
        PickerDialogFake.__init__(self, 'Display expenses and tags from', view.getWidget())
        self.set_size_request(-1, 280)
        self._view = view
        self._realized = False
        self._custom = custom
        self._on_timespan_selected = None
        self._on_timespan_selected_custom = None
        self.connect('realize', self.onRealize)
        self._selector = (TimespanSelector(view) if not(custom) else TimespanMonthSelector(view))
        self._selector.connect('changed', self.onChange)
        self.set_selector(self._selector)
        if self._custom:
            button = self.get_children()[0].get_children()[1].get_child().get_children()[1].get_children()[0]
            button.connect('button-release-event', self.onCustomSelected)
    def onRealize(self, widget, data=None):
        if not(self._realized):
            (selected, custom) = (0, 'Pick a month')
            if (self._view.getApp().getTimespan() == 'all'):
                selected = 1
            else:
                if (self._view.getApp().getTimespan() != 'month'):
                    selected = 2
            self._selector.append_row('Last month')
            self._selector.append_row('All time')
            self._selector.append_row(custom)
            self._selector.set_active(0, selected)
            self._realized = True
    def onChange(self, widget, column, data=None):
        if (self._realized and (column == 0)):
            i = self._selector.get_active(0)
            if (i > -1):
                destroy = self._on_timespan_selected(i, self._custom)
                if destroy:
                    self.destroy()
    def onCustomSelected(self, widget, data=None):
        month = (self._selector.get_active(1) + 1)
        year = (self._selector.get_active(2) + self._selector.getStartYear())
        self._on_timespan_selected_custom(year, month)
        self.destroy()
    def setOnTimespanSelected(self, cb):
        self._on_timespan_selected = cb
    def setOnTimespanSelectedCustom(self, cb):
        self._on_timespan_selected_custom = cb

class TimespanSelector(TextTouchSelector, ):
    def __init__(self, view):
        TextTouchSelector.__init__(self)
        self._view = view

class TimespanMonthSelector(TimespanSelector, ):
    def __init__(self, view):
        TimespanSelector.__init__(self, view)
        self._storeMonth = gtk.ListStore(str)
        self._storeYear = gtk.ListStore(int)
        self.connect('realize', self.onRealize)
        self.append_text_column(self._storeMonth, True)
        self.append_text_column(self._storeYear, True)
        for month in range(12):
            self._storeMonth.append((datetime.datetime(2000, (month + 1), 1).strftime('%B'),))
        year = datetime.datetime.now().year
        (startYear, endYear) = ((year - 10), (year + 10))
        self._startYear = startYear
        for year in range(startYear, endYear):
            self._storeYear.append((year,))
    def getStartYear(self):
        return self._startYear
    def onRealize(self, widget, data=None):
        self.set_active(0, 2)
        dt = (self._view.getApp().getTimespan() if (self._view.getApp().getTimespan() not in ('all', 'month')) else datetime.datetime.now())
        self.set_active(1, (dt.month - 1))
        self.set_active(2, ((dt.year - self._startYear) if (dt.year >= self._startYear) else 0))
