# coding=utf-8

import os, logging

config = {
    'data_path': '~/.toshl',
    'toshl_root': '/opt/toshl',
    'src_dir': 'src',
    'scheme_file': 'data/scheme.sql',
    'theme_file': '/usr/share/themes/toshl/gtk-2.0/gtkrc',
    'db_file': 'toshl.db',
    'currencies': {
        'EUR': ['Euro', u'€'],
        'USD': ['United States dollar', u'$'],
        'GBP': ['Pound Sterling', u'£'],
        'JPY': ['Japanese yen', u'¥'],
        'CNY': ['Chinese renminbi', u'¥'],
        'INR': ['Indian rupee', u'RS'],
        'CAD': ['Canadian dollar', u'$'],
        'AUD': ['Australian dollar', u'$'],
        'BRL': ['Brazilian real', u'R$'],
        'PLN': ['Polish złoty', u'zł'],
        'TRY': ['Turkish lira', u'TL'],
        'RUB': ['Russian ruble', u'pyб'],
        'SEK': ['Swedish krona', u'kr'],
        'HRK': ['Croatian kuna', u'kn'],
        'CHF': ['Swiss franc', u'CHF'],
    },
    'currencies_order': ('EUR', 'USD', 'GBP', 'JPY', 'CNY', 'INR', 'CAD', 'AUD', 'BRL', 'PLN', 'TRY', 'RUB', 'SEK', 'HRK', 'CHF'),
    'currency_default': 'EUR',
    'sync_options': [
        'on mobile connection or WiFi',
        'only when on WiFi',
        'don\'t sync',
    ],
    'log_file': 'log',
    'log_level': logging.WARN,
    'version': '1.5.5',
}

def get(name):
    return config[name]

def currency(abb):
    return get('currencies')[abb]

def joinData(path):
    return os.path.join(os.path.expanduser(config['data_path']), path)
    
def joinRoot(path):
    return os.path.join(config['toshl_root'], path)
    
def getThemeFile():
    return config['theme_file']

def getSchemeFile():
    return joinRoot(config['scheme_file'])

def getDbFile():
    return joinData(config['db_file'])
    
def getLogFile():
    return joinData(config['log_file'])
    
def getCurrencyFromSymbol(sym):
    for abb, data in get('currencies').items():
        if data[1] == sym:
            return abb
    return get('currency_default')
    
def getSymbolForCurrency(cur):
    if cur not in get('currencies'): cur = get('currency_default')
    return get('currencies')[cur][1]
    