#ifndef INFOWINDOW_H
#define INFOWINDOW_H

#include <QWidget>
#include <QScrollArea>
#include <QObject>
#include <QEvent>
#include "route.h"

class QScrollArea;
class QVBoxLayout;

class InfoWindow : public QScrollArea
{
Q_OBJECT
public:
    explicit InfoWindow();
    
    explicit InfoWindow( Route route, QWidget *parent = 0);
    
    explicit InfoWindow( const Route::List &routes, QWidget *parent = 0);
    
    void setRoute(Route route);
    
    void clearRoute();

signals:

public slots:
    
    void elementClicked(int);

protected:
        virtual bool event( QEvent *event);
private:

    QScrollArea *mScroll;
    Route mRoute;
    QVBoxLayout *mLayout;
    QWidgetList mList;
    const Route::List &mRoutes;
    
};

#endif // INFOWINDOW_H
