#include "location.h"
#include <QDebug>
#include <QStandardItem>

Location::Location(const QString &name, const int number, const QString &city,
             const int code, const QString &address, const int type,
             const QString &category, const  int x, const int y,
             const float longitude, const float latitude) : mName(name), mNumber(number), mCity(city),
        mCode(code), mAddress(address), mType(type), mX(x), mY(y),
        mLongitude(longitude), mLatitude(latitude)
{
    if (category == QString::fromLatin1("street") )
        mCategory = street;
    else if (category == QString::fromLatin1("stop") )
        mCategory = stop;
    else if (category == QString::fromLatin1("poi") )
        mCategory = poi;
    else
        mCategory = unknown;

}

Location::Location() {

}



void Location::debug() const {

    qDebug() << "LOC:" << mName << mNumber << mCity;

}

QStandardItem* Location::model() const {

    QStandardItem *temp;

    temp = new QStandardItem( toString() );

    return temp;

}

QString Location::toString() const {
    
    QString ret(mName);
    if (mNumber != 0)
        ret.append(QString::fromLatin1(" ") +
                   QString::number(mNumber));
    ret.append(QString::fromLatin1(" (") +
               mCity + QString::fromLatin1(")"));
    
    return ret;
    
}
FinnishCoordinates Location::finnishCoordinates() const {

    return makeFinnishCoordinates(mX, mY);
}
 

