#ifndef GPS_H
#define GPS_H

#include <QObject>
#include <QDateTime>
#ifdef GPS
#include <qmobilityglobal.h>
#include <qgeopositioninfo.h>
#endif

#include "coordinates.h"

class QDateTime;
class QTimer;

#ifdef GPS
QTM_BEGIN_NAMESPACE
        class QGeoPositionInfoSource;
class 	QGeoCoordinate;
QTM_END_NAMESPACE
	
        QTM_USE_NAMESPACE
        
#endif
        class Gps : public QObject
{
    Q_OBJECT
public:
    
    void getPosition();
    
    Coordinates currentPosition();
    
    void setAlarm(const Coordinates &place, const QDateTime &time);
    
    static Gps* instance();
    
    void init();
signals:
    
    void positionAvailable();
    
    void positionError();
    
    void alarmTriggered(const Coordinates &place);
    
public slots:
#ifdef GPS
    void positionUpdated(const QGeoPositionInfo & update);
#endif
    
    
private:
    explicit Gps();
#ifdef GPS
    QGeoPositionInfoSource *mGps;
    QGeoCoordinate mLastPos;
    QList<QGeoCoordinate> mAlarms;
#endif
    QList<QDateTime> mAlarmsTime;
    QDateTime closerTime;
    static Gps *data;
    
};

#endif // GPS_H
