#include "coordinates.h"
#include <math.h>
#include <QDebug>
//Code from:
//http://www.viestikallio.fi/tools/kkj-wgs84.php#KKJ-PI
//I have converted it, not analyzed so don't ask :)

const float PI = 3.1416;

float deg2rad ( float number ) {
    
    return (PI / 180) * number;
    
}

float rad2deg ( float number ) {
    
    return (180.0 / PI ) * number;
    
}

FinnishCoordinates KKJLaLo_to_KKJxy(Coordinates coords, int zoneNumber, float longitude) {
    //    // Following method is NOT excellent for more
    //    // than about 2deg from midline.
    //    // It might be usable within a meter for wider
    //    // projections
    
    float Lo = coords.first - longitude;
    
    float a  = 6378388.0;            // Hayford ellipsoid
    float f  = 1/297.0;
    
    //    $a  = 6378137.0;           // GRS80 -> WGS84
    //    $f  = 1/298.257222101;
    
    
    float b  = (1.0 - f) * a;
    float bb = b * b;              // b�
    float c  = (a / b) * a;       // c   = a�/b
    float ee = (a * a - bb) / bb; // e'� = (a� - b�)/b�
    float n = (a - b)/(a + b);   // n   = (a-b)/(a+b)
    float nn = n * n;              // n�
    
    float cosLa = cos(coords.second);
    
    float NN = ee * cosLa * cosLa; // Eta� = e'� cos� Latitude
    
    float LaF = atan(tan(coords.second) /
                     cos(Lo * sqrt(1 + NN)));
    
    float cosLaF = cos(LaF);
    
    float t   = (tan(Lo) * cosLaF) /
                sqrt(1 + ee * cosLaF * cosLaF);
    
    float A   = a / ( 1 + n );
    
    float A1  = A * (1 + nn / 4 + nn * nn / 64);
    
    float A2  = A * 1.5 * n * (1 - nn / 8);
    
    float A3  = A * 0.9375 * nn * (1 - nn / 4);
    
    float A4  = A * 35/48.0 * nn * n;
    
    float retLa = A1 * LaF -
                  A2 * sin(2*LaF) +
                  A3 * sin(4*LaF) -
                  A4 * sin(6*LaF);
    float retLo = c * log(t + sqrt(1+t*t)) +
                  500000.0 + zoneNumber * 1000000.0;
    
    ////printf("X1 = %.1f  X2 = %.1f  X3 = %.1f\nX4 = %.1f".
    ////       "  Lo0 = %.1f LaF = %.6f\n",
    ////       $A1 * $LaF,
    ////       0 - $A2 * sin(2*$LaF), 
    ////       0 + $A3 * sin(4*$LaF),
    ////       0 - $A4 * sin(6*$LaF), rad2deg(longitude), $LaF);
    ////printf("n = %.9f   nn = %.9f\n", $n, $nn);
    ////
    ////printf(" ED50: P = %.1f  I = %.1f\n",$OUT[X],$OUT[Y]);
    
    return makeFinnishCoordinates(retLo, retLa);
}

Coordinates KKJxy_to_KKJlalo(FinnishCoordinates coords, int zoneNumber, float longitude) {
    
    
    
    float minLa = deg2rad(59.0);
    float maxLa = deg2rad(70.5);
    float minLo = deg2rad(18.5);
    float maxLo = deg2rad(32.0);
    
    int i;
    
    float retLa=0;
    float retLo=0;
    
    for (i = 1; i < 35; ++i) {
        
        float deltaLa = maxLa - minLa;
        float deltaLo = maxLo - minLo;
        
        retLa = minLa + 0.5 * deltaLa;
        retLo = minLo + 0.5 * deltaLo;
        
        //        if ($Debug) {
        //            printf("Test%2d: %s  %s\n", $i,
        //                   fmtdms(retLa,1), fmtdms(retLo,0));
        //            printf("  Max:  %s  %s\n",
        //                   fmtdms(maxLa,1), fmtdms(maxLo,0));
        //            printf("  Min:  %s  %s\n",
        //                   fmtdms(minLa,1), fmtdms(minLo,0));
        //        }
        Coordinates temp = makeCoordinates(retLo, retLa);
        FinnishCoordinates coordsT  = KKJLaLo_to_KKJxy(temp, zoneNumber, longitude);
        
        //        if ($Debug) {
        //            printf("  KKJ: P = %7.3f  I = %7.3f\n",
        //                   $KKJt[X], $KKJt[Y]);
        //            printf("  Delta:   %7.3f      %7.3f\n",
        //                   $KKJt[X]-$KKJ[X], $KKJt[Y]-$KKJ[Y]);
        //        }
        
        if (coordsT.second < coords.second) {
            minLa = minLa + 0.45 * deltaLa;
        } else {
            maxLa = minLa + 0.55 * deltaLa;
        }
        
        if (coordsT.first < coords.first) {
            minLo = minLo + 0.45 * deltaLo;
        } else {
            maxLo = minLo + 0.55 * deltaLo;
        }
        
    }
    return makeCoordinates(retLo, retLa);
}

Coordinates WGSlalo_to_KKJlalo(Coordinates coords) {
    
    float La = rad2deg( coords.second );
    float Lo = rad2deg( coords.first );
    
    float dLa = deg2rad( -0.124766E+01       +
                         0.269941E+00 * La +
                         -0.191342E+00 * Lo +
                         -0.356086E-02 * La * La +
                         0.122353E-02 * La * Lo +
                         0.335456E-03 * Lo * Lo ) / 3600.0;
    float dLo = deg2rad(  0.286008E+02       +
                          -0.114139E+01 * La +
                          0.581329E+00 * Lo +
                          0.152376E-01 * La * La +
                          -0.118166E-01 * La * Lo +
                          -0.826201E-03 * Lo * Lo ) / 3600.0;
    
    float retLa = coords.second + dLa;
    float retLo = coords.first + dLo;
    
    return makeCoordinates(retLo, retLa);
}


FinnishCoordinates fromWgs84(Coordinates coords) {
    
    
    
    int zoneNumber = (int)(coords.first / 1000000.0);
    
    float longitude = 0.0;
    
    switch (zoneNumber) {
    case 1:
        longitude = 21.0;
        break;
    case 2:
        longitude = 24.0;
        break;
    case 3:
        longitude = 27.0;
        break;
    case 4:
        longitude = 30.0;
        break;
    default:
        break;
    }
    
    Coordinates temp = WGSlalo_to_KKJlalo(coords);
    return KKJLaLo_to_KKJxy(temp, zoneNumber, longitude);
}

Coordinates toWgs84(FinnishCoordinates coords) {
    
//    return KKJxy_to_KKJlalo(coords);
    
}
