#include "routewindow.h"
#include "route.h"
#include "displayinfowidget.h"

#include <QDebug>
#include <QVBoxLayout>
#include <QScrollArea>

RouteWindow::RouteWindow() :
        QScrollArea() 
{
    
//    setAttribute(Qt::WA_DeleteOnClose);
    setWindowFlags(windowFlags() | Qt::Window);
    setWindowTitle(tr("Transports:"));
    mLayout = new QVBoxLayout();
//    mLayout->setSizeConstraint(QLayout::SetMinimumSize);
    QWidget* widget = new QWidget(this); 
    widget->setLayout(mLayout);
    setWidget(widget);
    
}

RouteWindow::RouteWindow( Route route, QWidget *parent) :
        QScrollArea(parent )//, mRoute(route)
{
    
    //    route.debug();
    
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_DeleteOnClose);
    setWindowFlags(Qt::Window);
    setWindowTitle(tr("Transports:"));
    mLayout = new QVBoxLayout();
    mLayout->setSizeConstraint(QLayout::SetMinimumSize);
    QWidget* mainWidget = new QWidget(this); 
    mainWidget->setLayout(mLayout);
    setWidget(mainWidget);
    
    Transport trans = route.next();
    
    displayInfoWidget* widget;
    
    
    //    widget = new displayInfoWidget();
    //    widget->setTitle(QString::fromLatin1("test"));
    //    layout->addWidget(widget);
    
    while(! trans.isEmpty() ) {
        
        trans.debug();
        qDebug() << "trans" << trans.line();
        widget = new displayInfoWidget();
        widget->displayTransport(trans);
        mLayout->addWidget(widget);
        trans = route.next();
    }
    //    layout->addWidget(new QWidget());
    mLayout->update();
}

void RouteWindow::setRoute(Route route) {
    mRoute = route;
    
    Transport trans = route.next();
    
    displayInfoWidget* widget;
    
    
    //    widget = new displayInfoWidget();
    //    widget->setTitle(QString::fromLatin1("test"));
    //    layout->addWidget(widget);
    
    while(! trans.isEmpty() ) {
        
        trans.debug();
        qDebug() << "trans" << trans.line();
        widget = new displayInfoWidget();
        widget->displayTransport(trans);
        mLayout->addWidget(widget);
        mList.append(widget);
        trans = route.next();
    }
    
}

void RouteWindow::clearRoute() {
 
    foreach (QWidget* obj, mList) {
        mLayout->removeWidget(obj);
    }
}

bool RouteWindow::event( QEvent *event)
{
//    qDebug() << "EVENT" << event->type();
    if (event->type() == QEvent::Close) {
        deleteLater();
        hide();
        qDebug("No window");
        return false;
    } else
        // standard event processing
        return QWidget::event(event);
}
