#ifndef DISPLAYINFOWIDGET_H
#define DISPLAYINFOWIDGET_H

#include <QWidget>
#include "route.h"
#include "transport.h"
#include "stop.h"

#include <QPixmap>
#include <QList>

class QPushButton;
class QGridLayout;
class QLabel;
class QMouseEvent;

class displayInfoWidget : public QWidget
{
    Q_OBJECT
public:
    explicit displayInfoWidget(QWidget *parent = 0);
    
    ~displayInfoWidget();

    void setRoute(const Route &ruta);

    void displayTransport(const Transport &trans);
    
    void displayStop(const Stop &stop);

    void mouseReleaseEvent ( QMouseEvent * event );

    void setTitle(const QString &title);

    QSize sizeHint () const;

    QSizePolicy sizePolicy () const;

    void paintEvent(QPaintEvent *);

signals:

    void clicked();

public slots:

    void clear();
    
private slots:
    
    void displayStops();

private:

    QGridLayout *mGrid;
    QLabel *mIconLabel;
    QLabel *mTitleLabel;
    QLabel *mDescriptionLabel;
    QLabel *mLineLabel;
    QPushButton *mMapButton;
    QPushButton *mAlarmButton;
    QPixmap mIcon;
    Stop::List mStops;
    QList<QWidget*>  mWidgets;
    int state;


};

#endif // DISPLAYINFOWIDGET_H
