#include <QFileDialog>
#include <QMaemo5InformationBox>
#include <QMessageBox>
#include "ShareProgramDialog.h"
#include "ui_ShareProgramDialog.h"

#include "googledocumentlist.h"
#include "googledocument.h"
#include "googledocumentservice.h"

ShareProgramDialog::ShareProgramDialog(GoogleDocumentService *googleDoc,QWidget *parent) :
    QDialog(parent),
    ui(new Ui::ShareProgramDialog)
{
    ui->setupUi(this);
    ui->fileSelected->setEnabled(false);
    this->setWindowTitle("Share Program");
    this->googleDoc=googleDoc;

    connect(ui->downloadButton, SIGNAL(clicked()), this, SLOT(downloadButtonClickedSlot()));
    connect(ui->uploadButton, SIGNAL(clicked()), this, SLOT(uploadButtonClickedSlot()));
    connect(ui->refreshButton, SIGNAL(clicked()), this, SLOT(refreshButtonClicked()));
    connect(googleDoc, SIGNAL(listDone(bool)), this, SLOT(listDone(bool)));
    connect(googleDoc, SIGNAL(downloadDone(bool)), this, SLOT(downloadDone(bool)));
    connect(googleDoc, SIGNAL(uploadDone(bool)), this, SLOT(downloadDone(bool)));
    connect(googleDoc, SIGNAL(downloadProgress(qint64,qint64)), this, SLOT(updateProgressBar(qint64,qint64)));
    connect(googleDoc, SIGNAL(uploadProgress(qint64,qint64)), this, SLOT(updateProgressBar(qint64,qint64)));
    connect(ui->browserButton,SIGNAL(clicked()),this,SLOT(browseButtonClicked()));
    ui->tabWidget->setCurrentIndex(0);
    refreshButtonClicked();
    this->resize(500,370);
}

ShareProgramDialog::~ShareProgramDialog()
{
    delete ui;
}

void ShareProgramDialog::browseButtonClicked()
{
    selectedFileName = QFileDialog::getOpenFileName(this,tr("Open File"), QDir::currentPath(),"*c *cpp *cc");
    ui->fileSelected->setText(selectedFileName);
}

void ShareProgramDialog::uploadButtonClickedSlot()
{
    if(ui->fileSelected->text() == "" || ui->titleLineEdit->text() == "")
    {
        QMessageBox::information(this,"Incomplete parameters","Please enter both filename and title");
        return;
    }
    else
    {
        ui->fileSelected->setEnabled(false);
        ui->titleLineEdit->setEnabled(false);
        ui->uploadButton->setEnabled(false);
        googleDoc->uploadDocument(&ui->fileSelected->text(), &ui->titleLineEdit->text());
        connect(googleDoc, SIGNAL(uploadDone(bool)), this, SLOT(uploadDoneSlot(bool)));
    }
}


void ShareProgramDialog::refreshButtonClicked()
{
    ui->tabWidget->setEnabled(false);
    ui->downloadButton->setEnabled(false);
    ui->refreshButton->setEnabled(false);
    ui->downloadProgressBar->setMinimum(0);
    ui->downloadProgressBar->setMaximum(0);
    ui->downloadProgressBar->setVisible(true);
    googleDoc->listDocuments();
}

void ShareProgramDialog::listDone(bool done)
{
    if(done) {
        ui->programsList->clear();

        QList<GoogleDocument *> list;

        //list = googleDoc->documentList;
        list = googleDoc->othersList;
        foreach(GoogleDocument *i, list) {
            ui->programsList->addItem(i->title());
        }
    }
    else {
        QMaemo5InformationBox::information(this, "<p><b>Error</b></p> <p>An error occured while retrieving document list</p>", QMaemo5InformationBox::NoTimeout);
    }
    ui->downloadProgressBar->setMaximum(100);
    ui->downloadProgressBar->setVisible(false);
    ui->tabWidget->setEnabled(true);
    ui->downloadButton->setEnabled(true);
    ui->refreshButton->setEnabled(true);
}

void ShareProgramDialog::downloadButtonClickedSlot()
{
    QList<GoogleDocument *> list;

    if(-1 == ui->programsList->currentRow()) {
        QMaemo5InformationBox::information(this, "Select a file from the list to download", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    list=googleDoc->othersList;

    GoogleDocument *doc = list[ui->programsList->currentRow()];

    QString fileName = QFileDialog::getSaveFileName(this, tr("Save as..."),
                                              QString(), "C File (*.c);;CPP files (*.cpp);;All Files (*)");

    if (fileName.isEmpty())
        return;

    if (! (fileName.endsWith(".c", Qt::CaseInsensitive) || fileName.endsWith(".cpp", Qt::CaseInsensitive) || fileName.endsWith(".txt", Qt::CaseInsensitive)) )
        fileName += ".c";

    googleDoc->downloadDocument(doc, new QString(fileName));
    ui->tabWidget->setEnabled(false);
    ui->downloadButton->setEnabled(false);
    ui->refreshButton->setEnabled(false);
    ui->downloadProgressBar->setVisible(true);
}

void ShareProgramDialog::downloadDone(bool status)
{
    ui->downloadProgressBar->setVisible(false);
    ui->uploadProgressBar->setVisible(false);

    ui->downloadProgressBar->setValue(0);
    ui->tabWidget->setEnabled(true);
    ui->downloadButton->setEnabled(true);
    ui->refreshButton->setEnabled(true);
    ui->uploadButton->setEnabled(true);

    ui->fileSelected->setEnabled(true);
    ui->titleLineEdit->setEnabled(true);
    ui->uploadButton->setEnabled(true);

    ui->fileSelected->setText("");
    ui->titleLineEdit->setText("");

    if(status) {
        if(ui->tabWidget->currentIndex()==0)
            QMaemo5InformationBox::information(this, "File Downloaded Successfully", QMaemo5InformationBox::DefaultTimeout);
        else
            QMaemo5InformationBox::information(this, "File Uploaded Successfully", QMaemo5InformationBox::DefaultTimeout);
    }
    else {
        if(ui->tabWidget->currentIndex()==0)
            QMaemo5InformationBox::information(this, "<p><b>Error</b></p> <p>An error occured while downloading the program file</p>", QMaemo5InformationBox::NoTimeout);
        else
            QMaemo5InformationBox::information(this, "<p><b>Error</b></p> <p>An error occured while uploading the program file</p>", QMaemo5InformationBox::NoTimeout);
    }

}

void ShareProgramDialog::updateProgressBar(qint64 doneBytes, qint64 totalBytes)
{
    int value = (doneBytes * 100) / totalBytes;
    if(ui->tabWidget->currentIndex()==0)
        ui->downloadProgressBar->setValue(value);
    else
        ui->uploadProgressBar->setValue(value);
}


void ShareProgramDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
