#include "scannerthread.h"
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <QInputDialog>
#include <QMutex>
#include <QFile>
#include <QTextStream>
//#include <QDebug>
#include <QMessageBox>
#include <QFileDialog>

ScannerThread::ScannerThread(QObject *parent)
    : QThread(parent)
{
    this->stopFlag=false;
    m_bToSuspend=false;
}
void ScannerThread::run()
{
    QMutex waitMutex;
    sleep(2);
        while(stopFlag==false)
        {
            QFile pidFile("/tmp/pid.ec");
            QString pid;
            if(pidFile.exists())
            {
                if (pidFile.open(QFile::ReadOnly))
                {
                    QTextStream out(&pidFile);
                    pid=out.readAll();
                }
                //qDebug()<<pid;
                pidFile.close();
                //pid.trimmed();
                QFile status("/proc/"+pid+"/status");
                if(status.exists())
                {
                    if (status.open(QFile::ReadOnly))
                    {
                        QTextStream out(&status);
                        QString buffer=out.readAll();
                        QStringList afterSplit=buffer.split("\n");
                        //qDebug()<<afterSplit[1];
                        if(afterSplit[1].contains("sleeping"))
                        {
                            emit showScanDialog();
                            //system("scanf");
                        }
                    }
                }
                else
                {
                    //qDebug()<<pid<<"\nnot found";
                    //QMessageBox::warning(this, tr("Application"),tr("check program pid not found"));
                }
            }

             if (m_bToSuspend)
             {
                m_waitCondt.wait(&waitMutex);
             }
        }
}
void ScannerThread::suspend()
{
    m_bToSuspend = true;
}

void ScannerThread::resume()
{
    if (!m_bToSuspend)
        return;

    m_bToSuspend = false;
    m_waitCondt.wakeOne();
}
